/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Area;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISAreasInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final Player p;
    private final Inventory inventory;

    public TARDISAreasInventory(TARDIS plugin, Player p) {
        this.plugin = plugin;
        this.p = p;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS areas", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ArrayList<ItemStack> areas = new ArrayList<ItemStack>();
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, null, true, false);
        int i = 0;
        if (rsa.resultSet()) {
            for (Area a : rsa.getData()) {
                String name = a.areaName();
                if (!TARDISPermission.hasPermission(this.p, "tardis.area." + name) && !TARDISPermission.hasPermission(this.p, "tardis.area.*")) continue;
                ItemStack is = ItemStack.of((Material)TARDISConstants.GUI_IDS.get(i), (int)1);
                ItemMeta im = is.getItemMeta();
                im.displayName((Component)Component.text((String)name));
                im.lore(List.of(Component.text((String)a.world())));
                is.setItemMeta(im);
                areas.add(is);
                ++i;
            }
        }
        ItemStack[] stack = new ItemStack[54];
        for (int s = 0; s < 45; ++s) {
            stack[s] = s < areas.size() ? (ItemStack)areas.get(s) : null;
        }
        ItemStack map = ItemStack.of((Material)Material.MAP, (int)1);
        ItemMeta switchto = map.getItemMeta();
        switchto.displayName((Component)Component.text((String)"Load TARDIS saves"));
        map.setItemMeta(switchto);
        for (int m = 45; m < 54; ++m) {
            stack[m] = m == 49 ? map : null;
        }
        return stack;
    }
}

