/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.skins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class SkinFetcher {
    private final TARDIS plugin;
    private final UUID uuid;
    private JsonObject skin;

    public SkinFetcher(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
    }

    public void fetchAsync(SkinCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            boolean hasResult = this.fetch();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onDone(hasResult, this));
        });
    }

    public boolean fetch() {
        String id = this.uuid.toString().replace("-", "");
        try {
            URL url = URI.create(String.format("https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false", id)).toURL();
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.connect();
            if (connection.getResponseCode() == 200) {
                JsonElement root = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)connection.getContent()));
                JsonObject rootObj = root.getAsJsonObject();
                JsonArray jsonArray = rootObj.getAsJsonArray("properties");
                this.skin = jsonArray.get(0).getAsJsonObject();
                return true;
            }
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.HELPER_WARNING, "Connection could not be opened (Response code " + connection.getResponseCode() + ", " + connection.getResponseMessage() + ")");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public JsonObject getSkin() {
        return this.skin;
    }

    public static interface SkinCallback {
        public void onDone(boolean var1, SkinFetcher var2);
    }
}

