/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.recipes.shaped;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.CraftingDifficulty;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TimeRotorCustomRecipe {
    private final TARDIS plugin;

    public TimeRotorCustomRecipe(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void addRecipes() {
        for (String r : this.plugin.getCustomRotorsConfig().getKeys(false)) {
            try {
                Material material = Material.valueOf((String)this.plugin.getCustomRotorsConfig().getString(r + ".animated_material"));
                ItemStack is = ItemStack.of((Material)Material.LIGHT_GRAY_DYE, (int)1);
                ItemMeta im = is.getItemMeta();
                String dn = TARDISStringUtils.capitalise(r);
                im.displayName((Component)ComponentUtils.toWhite("Time Rotor " + dn));
                im.setItemModel(new NamespacedKey((Plugin)this.plugin, "time_rotor_" + r + "_off"));
                is.setItemMeta(im);
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "time_rotor_" + r);
                ShapedRecipe recipe = new ShapedRecipe(key, is);
                recipe.shape(new String[]{"CRC", "GWG", "GRG"});
                recipe.setIngredient('C', material);
                recipe.setIngredient('W', Material.CLOCK);
                recipe.setIngredient('G', Material.GLASS_PANE);
                if (this.plugin.getCraftingDifficulty() == CraftingDifficulty.HARD) {
                    recipe.setIngredient('R', Material.REDSTONE_BLOCK);
                } else {
                    recipe.setIngredient('R', Material.REDSTONE);
                }
                this.plugin.getServer().addRecipe((Recipe)recipe);
                this.plugin.getFigura().getShapedRecipes().put("Time Rotor " + dn, recipe);
            }
            catch (IllegalArgumentException e) {
                this.plugin.debug("Invalid custom rotor item material for " + r + "!");
            }
        }
    }
}

