/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.recipes.shaped;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.models.ColourType;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ConsoleCustomRecipe {
    private final TARDIS plugin;
    private final List<Material> used = List.of(Material.WHITE_CONCRETE, Material.ORANGE_CONCRETE, Material.MAGENTA_CONCRETE, Material.LIGHT_BLUE_CONCRETE, Material.YELLOW_CONCRETE, Material.LIME_CONCRETE, Material.PINK_CONCRETE, Material.GRAY_CONCRETE, Material.LIGHT_GRAY_CONCRETE, Material.CYAN_CONCRETE, Material.PURPLE_CONCRETE, Material.BLUE_CONCRETE, Material.BROWN_CONCRETE, Material.GREEN_CONCRETE, Material.RED_CONCRETE, Material.BLACK_CONCRETE, Material.WAXED_OXIDIZED_COPPER);

    public ConsoleCustomRecipe(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void addRecipes() {
        for (String console : this.plugin.getCustomConsolesConfig().getConfigurationSection("consoles").getKeys(false)) {
            try {
                Material material = Material.valueOf((String)this.plugin.getCustomConsolesConfig().getString("consoles." + console + ".material"));
                if (!this.used.contains(material)) {
                    ItemStack is = ItemStack.of((Material)material, (int)1);
                    ItemMeta im = is.getItemMeta();
                    String dn = TARDISStringUtils.capitalise(console) + " Console";
                    im.displayName((Component)ComponentUtils.toWhite(dn));
                    im.lore(List.of(Component.text((String)"Integration with interaction")));
                    String pdc = "console_" + console;
                    im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)pdc);
                    is.setItemMeta(im);
                    NamespacedKey key = new NamespacedKey((Plugin)this.plugin, console + "_console");
                    ShapedRecipe r = new ShapedRecipe(key, is);
                    r.shape(new String[]{"CBC", "ORO", "CBC"});
                    r.setIngredient('C', material);
                    r.setIngredient('O', Material.COMPARATOR);
                    r.setIngredient('R', Material.REDSTONE_BLOCK);
                    r.setIngredient('B', Material.BAMBOO_BUTTON);
                    this.plugin.getServer().addRecipe((Recipe)r);
                    this.plugin.getFigura().getShapedRecipes().put(dn, r);
                    ColourType.BY_MATERIAL.put(material, new NamespacedKey((Plugin)this.plugin, pdc));
                    continue;
                }
                this.plugin.debug("Custom console material for " + console + "is already in use!");
            }
            catch (IllegalArgumentException e) {
                this.plugin.debug("Invalid custom console material for " + console + "!");
            }
        }
    }
}

