/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.recipes;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.SonicVariant;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class TARDISShowShapelessRecipeInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final ShapelessRecipe recipe;
    private final Inventory inventory;
    private final String str;

    public TARDISShowShapelessRecipeInventory(TARDIS plugin, ShapelessRecipe recipe, String str) {
        this.plugin = plugin;
        this.recipe = recipe;
        this.str = str;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 27, (Component)Component.text((String)(str + " recipe"), (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getRecipeItems());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getRecipeItems() {
        RecipeItem recipeItem;
        ItemStack[] stacks = new ItemStack[27];
        List ingredients = this.recipe.getChoiceList();
        int glowstoneCount = 0;
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack item = null;
            RecipeChoice choice = (RecipeChoice)ingredients.get(i);
            if (choice instanceof RecipeChoice.ExactChoice) {
                RecipeChoice.ExactChoice exact = (RecipeChoice.ExactChoice)choice;
                item = exact.getItemStack();
            } else if (choice instanceof RecipeChoice.MaterialChoice) {
                RecipeChoice.MaterialChoice mat = (RecipeChoice.MaterialChoice)choice;
                item = mat.getItemStack();
            }
            if (item == null) continue;
            ItemMeta im = item.getItemMeta();
            if (item.getType().equals((Object)Material.GLOWSTONE_DUST)) {
                String dn = this.getDisplayName(this.str, glowstoneCount);
                im.displayName((Component)ComponentUtils.toWhite(dn));
                ++glowstoneCount;
            }
            if (item.getType().equals((Object)Material.MUSIC_DISC_STRAD)) {
                im.displayName((Component)Component.text((String)"Blank Storage Disk"));
                im.addItemFlags(ItemFlag.values());
                im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
            }
            if (item.getType().equals((Object)Material.BLAZE_ROD)) {
                im.displayName((Component)Component.text((String)"Sonic Screwdriver"));
                CustomModelDataComponent component = im.getCustomModelDataComponent();
                component.setFloats(SonicVariant.TENTH.getFloats());
                im.setCustomModelDataComponent(component);
            }
            item.setItemMeta(im);
            stacks[i * 9] = item;
        }
        ItemStack result = this.recipe.getResult();
        ItemMeta im = result.getItemMeta();
        im.displayName((Component)ComponentUtils.toWhite(this.str));
        if (this.str.equals("Blank Storage Disk") || this.str.equals("Save Storage Disk") || this.str.equals("Preset Storage Disk") || this.str.equals("Biome Storage Disk") || this.str.equals("Player Storage Disk") || this.str.equals("Authorised Control Disk")) {
            im.addItemFlags(ItemFlag.values());
            im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
        }
        if ((recipeItem = RecipeItem.getByName(this.str)) != RecipeItem.NOT_FOUND && recipeItem.getCategory().equals((Object)RecipeCategory.SONIC_UPGRADES)) {
            im.displayName((Component)ComponentUtils.toWhite("Sonic Screwdriver"));
            im.lore(List.of(Component.text((String)"Upgrades:"), Component.text((String)this.str)));
        }
        result.setAmount(1);
        result.setItemMeta(im);
        stacks[17] = result;
        return stacks;
    }

    private String getDisplayName(String recipe, int quartzCount) {
        switch (recipe) {
            case "TARDIS Locator": {
                return "TARDIS Locator Circuit";
            }
            case "Stattenheim Remote": {
                return "TARDIS Stattenheim Circuit";
            }
            case "TARDIS Chameleon Circuit": 
            case "TARDIS Remote Key": {
                return "TARDIS Materialisation Circuit";
            }
            case "TARDIS Invisibility Circuit": 
            case "Perception Filter": {
                return "Perception Circuit";
            }
            case "Sonic Screwdriver": 
            case "Server Admin Circuit": 
            case "Sonic Dock": {
                return "Sonic Oscillator";
            }
            case "Fob Watch": 
            case "Preset Storage Disk": 
            case "TARDIS Television": {
                return "TARDIS Chameleon Circuit";
            }
            case "TARDIS Biome Reader": 
            case "Emerald Upgrade": {
                return "Emerald Environment Circuit";
            }
            case "Rift Manipulator": {
                return "Rift Circuit";
            }
            case "Admin Upgrade": {
                return "Server Admin Circuit";
            }
            case "Bio-scanner Upgrade": {
                return "Bio-scanner Circuit";
            }
            case "Redstone Upgrade": {
                return "Redstone Activator Circuit";
            }
            case "Diamond Upgrade": {
                return "Diamond Disruptor Circuit";
            }
            case "Painter Upgrade": {
                return "Painter Circuit";
            }
            case "Ignite Upgrade": {
                return "Ignite Circuit";
            }
            case "Pickup Arrows Upgrade": {
                return "Pickup Arrows Circuit";
            }
            case "Knockback Upgrade": {
                return "Knockback Circuit";
            }
            case "Brush Upgrade": {
                return "Brush Circuit";
            }
            case "Conversion Upgrade": {
                return "Conversion Circuit";
            }
        }
        if (quartzCount == 0) {
            return "TARDIS Locator Circuit";
        }
        return "TARDIS Materialisation Circuit";
    }
}

