/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.playerprefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.playerprefs.TARDISKeyMenuInventory;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class TARDISKeyMenuListener
extends TARDISMenuListener {
    public static final TreeMap<Material, NamedTextColor> COLOUR_LOOKUP = new TreeMap();
    public static final HashMap<NamedTextColor, Material> REVERSE_LOOKUP = new HashMap();
    private final Material material;

    public TARDISKeyMenuListener(TARDIS plugin) {
        super(plugin);
        Material keyMaterial;
        COLOUR_LOOKUP.put(Material.WHITE_WOOL, NamedTextColor.WHITE);
        COLOUR_LOOKUP.put(Material.MAGENTA_WOOL, NamedTextColor.LIGHT_PURPLE);
        COLOUR_LOOKUP.put(Material.PINK_WOOL, NamedTextColor.RED);
        COLOUR_LOOKUP.put(Material.ORANGE_WOOL, NamedTextColor.GOLD);
        COLOUR_LOOKUP.put(Material.YELLOW_WOOL, NamedTextColor.YELLOW);
        COLOUR_LOOKUP.put(Material.LIME_WOOL, NamedTextColor.GREEN);
        COLOUR_LOOKUP.put(Material.CYAN_WOOL, NamedTextColor.AQUA);
        COLOUR_LOOKUP.put(Material.LIGHT_BLUE_WOOL, NamedTextColor.BLUE);
        COLOUR_LOOKUP.put(Material.PURPLE_WOOL, NamedTextColor.DARK_PURPLE);
        COLOUR_LOOKUP.put(Material.RED_WOOL, NamedTextColor.DARK_RED);
        COLOUR_LOOKUP.put(Material.GREEN_WOOL, NamedTextColor.DARK_GREEN);
        COLOUR_LOOKUP.put(Material.BROWN_WOOL, NamedTextColor.DARK_AQUA);
        COLOUR_LOOKUP.put(Material.BLUE_WOOL, NamedTextColor.DARK_BLUE);
        COLOUR_LOOKUP.put(Material.LIGHT_GRAY_WOOL, NamedTextColor.GRAY);
        COLOUR_LOOKUP.put(Material.GRAY_WOOL, NamedTextColor.DARK_GRAY);
        COLOUR_LOOKUP.put(Material.BLACK_WOOL, NamedTextColor.BLACK);
        for (Map.Entry<Material, NamedTextColor> map : COLOUR_LOOKUP.entrySet()) {
            REVERSE_LOOKUP.put(map.getValue(), map.getKey());
        }
        try {
            keyMaterial = Material.valueOf((String)plugin.getConfig().getString("preferences.key"));
        }
        catch (IllegalArgumentException e) {
            keyMaterial = Material.GOLD_NUGGET;
        }
        this.material = keyMaterial;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPrefsMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISKeyMenuInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 26) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                TARDIS.plugin.debug("TARDISKeyMenuListener");
                event.setCancelled(true);
            }
            return;
        }
        InventoryView view = event.getView();
        switch (slot) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                event.setCancelled(true);
                ItemStack key = view.getItem(18);
                if (key == null || !key.getType().equals((Object)this.material) || !key.hasItemMeta()) {
                    return;
                }
                ItemStack choice = view.getItem(slot);
                ItemMeta choiceMeta = choice.getItemMeta();
                ItemMeta keyMeta = key.getItemMeta();
                CustomModelDataComponent component = choiceMeta.getCustomModelDataComponent();
                CustomModelDataComponent transfer = keyMeta.getCustomModelDataComponent();
                transfer.setFloats(component.getFloats());
                keyMeta.setCustomModelDataComponent(transfer);
                keyMeta.getPersistentDataContainer().set(TARDIS.plugin.getTimeLordUuidKey(), TARDIS.plugin.getPersistentDataTypeUUID(), (Object)player.getUniqueId());
                ArrayList<Component> lore = keyMeta.hasLore() ? keyMeta.lore() : new ArrayList<Component>();
                Component belongs = Component.text((String)"This key belongs to", (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.ITALIC);
                if (lore != null && !lore.contains(belongs)) {
                    lore.add(belongs);
                    lore.add(Component.text((String)player.getName(), (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.ITALIC));
                    keyMeta.lore(lore);
                }
                key.setItemMeta(keyMeta);
                break;
            }
            case 18: {
                ItemStack cursor = event.getCursor();
                if (!cursor.getType().equals((Object)Material.BLAZE_ROD) || !cursor.hasItemMeta()) {
                    return;
                }
                ItemMeta meta = cursor.getItemMeta();
                if (!meta.hasDisplayName()) {
                    return;
                }
                NamedTextColor color = TARDISStaticUtils.getColor(meta.displayName());
                Material wool = REVERSE_LOOKUP.getOrDefault(color, Material.WHITE_WOOL);
                view.setItem(19, ItemStack.of((Material)wool));
                break;
            }
            case 19: {
                event.setCancelled(true);
                ItemStack key = view.getItem(18);
                if (key == null || !key.getType().equals((Object)this.material) || !key.hasItemMeta()) {
                    return;
                }
                ItemStack choice = view.getItem(19);
                Material wool = this.getNextWool(choice.getType());
                view.setItem(19, ItemStack.of((Material)wool));
                NamedTextColor display = COLOUR_LOOKUP.get(wool);
                ItemMeta key_im = key.getItemMeta();
                key_im.displayName(Component.text((String)"TARDIS Key", (TextColor)display).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE));
                key.setItemMeta(key_im);
                break;
            }
            case 26: {
                event.setCancelled(true);
                this.close(player);
                break;
            }
            default: {
                event.setCancelled(true);
            }
        }
    }

    private Material getNextWool(Material current) {
        Material index = COLOUR_LOOKUP.higherKey(current);
        return index != null ? index : COLOUR_LOOKUP.firstKey();
    }

    @EventHandler(ignoreCancelled=true)
    public void onKeyMenuClose(InventoryCloseEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISKeyMenuInventory)) {
            return;
        }
        InventoryView view = event.getView();
        ItemStack key = view.getItem(18);
        if (key != null) {
            Player p = (Player)event.getPlayer();
            Location loc = p.getLocation();
            loc.getWorld().dropItemNaturally(loc, key);
            view.setItem(18, ItemStack.of((Material)Material.AIR));
        }
    }
}

