/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.playerprefs;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.playerprefs.TARDISHumInventory;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISHumListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<Integer, Long> sounds = new HashMap();
    private final HashMap<UUID, Long> cooldown = new HashMap();
    private final HashMap<UUID, Integer> last = new HashMap();

    public TARDISHumListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.sounds.put(0, 27402L);
        this.sounds.put(1, 40594L);
        this.sounds.put(2, 68519L);
        this.sounds.put(3, 46026L);
        this.sounds.put(4, 51632L);
        this.sounds.put(5, 64313L);
        this.sounds.put(6, 75000L);
        this.sounds.put(7, 80379L);
        this.sounds.put(8, 70656L);
        this.sounds.put(9, 52950L);
        this.sounds.put(10, 77296L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPrefsMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISHumInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 17) {
            return;
        }
        InventoryView view = event.getView();
        ItemStack is = view.getItem(slot);
        if (is == null) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        UUID uuid = p.getUniqueId();
        ItemMeta im = is.getItemMeta();
        switch (slot) {
            case 11: {
                HashMap<String, Object> setr = new HashMap<String, Object>();
                HashMap<String, Object> wherer = new HashMap<String, Object>();
                wherer.put("uuid", uuid.toString());
                setr.put("hum", "");
                this.plugin.getQueryFactory().doUpdate("player_prefs", setr, wherer);
                this.close(p);
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "HUM_SAVED");
                break;
            }
            case 15: {
                if (this.isPlay(view)) {
                    this.setPlay(view, "SAVE");
                    break;
                }
                this.setPlay(view, "PLAY");
                break;
            }
            case 17: {
                this.close(p);
                break;
            }
            default: {
                if (this.isPlay(view)) {
                    long now = System.currentTimeMillis();
                    if (this.cooldown.containsKey(uuid) && now < this.cooldown.get(uuid) + this.sounds.get(this.last.get(uuid))) {
                        this.close(p);
                        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "HUM_WAIT");
                        break;
                    }
                    TARDISSounds.playTARDISSound(p, "tardis_hum_" + ComponentUtils.stripColour(im.displayName()).toLowerCase(Locale.ROOT), 5L);
                    this.last.put(uuid, slot);
                    this.cooldown.put(uuid, System.currentTimeMillis());
                    break;
                }
                HashMap<String, Object> set = new HashMap<String, Object>();
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", uuid.toString());
                set.put("hum", ComponentUtils.stripColour(im.displayName()).toLowerCase(Locale.ROOT));
                this.plugin.getQueryFactory().doUpdate("player_prefs", set, where);
                this.close(p);
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "HUM_SAVED");
            }
        }
    }

    private void setPlay(InventoryView view, String str) {
        ItemStack play = view.getItem(15);
        ItemMeta save = play.getItemMeta();
        save.lore(List.of(Component.text((String)str)));
        play.setItemMeta(save);
    }

    private boolean isPlay(InventoryView view) {
        ItemStack play = view.getItem(15);
        ItemMeta save = play.getItemMeta();
        return ComponentUtils.endsWith((Component)save.lore().getFirst(), "PLAY");
    }
}

