/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.monitor;

import java.awt.Color;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.monitor.MaterialColour;
import me.eccentric_nz.TARDIS.monitor.SkyColour;
import me.eccentric_nz.TARDIS.monitor.SnapshotStorage;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class SnapshotRenderer
extends MapRenderer {
    private final Location location;
    private final int distance;

    public SnapshotRenderer(Location location, int distance) {
        this.location = location;
        this.distance = distance;
    }

    public void render(MapView map, MapCanvas canvas, Player player) {
        if (map.isLocked()) {
            return;
        }
        double pitch = -Math.toRadians(this.location.getPitch());
        double yaw = Math.toRadians(this.location.getYaw() + 90.0f);
        World world = this.location.getWorld();
        Color[][] canvasColours = new Color[128][128];
        for (int x = 0; x < 128; ++x) {
            for (int y = 0; y < 128; ++y) {
                double yrotate = -((double)y * 0.9 / 128.0 - 0.45);
                double xrotate = (double)x * 0.9 / 128.0 - 0.45;
                Vector rayTraceVector = new Vector(Math.cos(yaw + xrotate) * Math.cos(pitch + yrotate), Math.sin(pitch + yrotate), Math.sin(yaw + xrotate) * Math.cos(pitch + yrotate));
                RayTraceResult result = world.rayTraceBlocks(this.location, rayTraceVector, (double)this.distance);
                RayTraceResult liquidResult = world.rayTraceBlocks(this.location, rayTraceVector, (double)this.distance, FluidCollisionMode.ALWAYS, false);
                double[] dye = new double[]{1.0, 1.0, 1.0};
                if (liquidResult != null) {
                    if (liquidResult.getHitBlock().getType().equals((Object)Material.WATER)) {
                        dye = new double[]{0.5, 0.5, 1.0};
                    }
                    if (liquidResult.getHitBlock().getType().equals((Object)Material.LAVA)) {
                        dye = new double[]{1.0, 0.3, 0.3};
                    }
                }
                if (result != null) {
                    byte lightLevel = result.getHitBlock().getRelative(result.getHitBlockFace()).getLightLevel();
                    if (lightLevel > 0) {
                        for (int i = 0; i < dye.length; ++i) {
                            dye[i] = dye[i] * ((double)lightLevel / 15.0);
                        }
                    }
                    Color color = MaterialColour.colourFromType(result.getHitBlock(), dye);
                    canvas.setPixelColor(x, y, color);
                    canvasColours[x][y] = color;
                    continue;
                }
                if (liquidResult != null) {
                    Color color = MaterialColour.colourFromType(liquidResult.getHitBlock(), new double[]{1.0, 1.0, 1.0});
                    canvas.setPixelColor(x, y, color);
                    canvasColours[x][y] = color;
                    continue;
                }
                Color c = Color.gray;
                if (!world.getName().contains("TARDIS")) {
                    block0 : switch (world.getEnvironment()) {
                        case NETHER: {
                            switch (this.location.getBlock().getBiome().getKey().getKey()) {
                                case "basalt_deltas": {
                                    c = new Color(90, 80, 95);
                                    break block0;
                                }
                                case "crimson_forest": {
                                    c = new Color(35, 5, 5);
                                    break block0;
                                }
                                case "warped_forest": {
                                    c = new Color(10, 10, 50);
                                    break block0;
                                }
                                case "soul_sand_valley": {
                                    c = new Color(35, 90, 80);
                                    break block0;
                                }
                            }
                            c = new Color(50, 15, 15);
                            break;
                        }
                        case THE_END: {
                            c = new Color(30, 20, 50);
                            break;
                        }
                        default: {
                            long ticks = world.getTime();
                            c = world.getName().equals("skaro") ? SkyColour.getSkaroFromTime(ticks) : (world.getName().equals("gallifrey") ? SkyColour.getGallifreyFromTime(ticks) : SkyColour.getNormalFromTime(ticks));
                        }
                    }
                }
                canvas.setPixelColor(x, y, c);
                canvasColours[x][y] = c;
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)TARDIS.plugin, () -> new SnapshotStorage().store(map.getId(), canvasColours));
        map.setLocked(true);
    }
}

