/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.monitor;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.monitor.Snapshot;
import me.eccentric_nz.TARDIS.monitor.SnapshotRenderer;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.util.BoundingBox;

public class MonitorUtils {
    public static ItemStack createMap(Location location, int distance) {
        ItemStack itemStack = ItemStack.of((Material)Material.FILLED_MAP);
        MapMeta mapMeta = (MapMeta)itemStack.getItemMeta();
        MapView mapView = Bukkit.createMap((World)location.getWorld());
        mapView.setTrackingPosition(false);
        for (MapRenderer renderer : mapView.getRenderers()) {
            mapView.removeRenderer(renderer);
        }
        SnapshotRenderer renderer = new SnapshotRenderer(location, distance);
        mapView.addRenderer((MapRenderer)renderer);
        mapMeta.setMapView(mapView);
        itemStack.setItemMeta((ItemMeta)mapMeta);
        return itemStack;
    }

    public static void createSnapshot(Location location, Player player, int distance) {
        ItemStack itemStack = ItemStack.of((Material)Material.FILLED_MAP);
        MapMeta mapMeta = (MapMeta)itemStack.getItemMeta();
        MapView mapView = Bukkit.createMap((World)location.getWorld());
        mapView.setTrackingPosition(false);
        for (MapRenderer renderer : mapView.getRenderers()) {
            mapView.removeRenderer(renderer);
        }
        SnapshotRenderer renderer = new SnapshotRenderer(location, distance);
        mapView.addRenderer((MapRenderer)renderer);
        mapMeta.setMapView(mapView);
        itemStack.setItemMeta((ItemMeta)mapMeta);
        player.getInventory().addItem(new ItemStack[]{itemStack});
    }

    public static void updateSnapshot(Location location, int distance, ItemStack map) {
        MapMeta mapMeta = (MapMeta)map.getItemMeta();
        MapView mapView = null;
        if (mapMeta.hasMapView()) {
            mapView = mapMeta.getMapView();
        }
        if (mapView == null) {
            mapView = Bukkit.createMap((World)location.getWorld());
        }
        mapView.setTrackingPosition(false);
        mapView.setLocked(false);
        for (MapRenderer renderer : mapView.getRenderers()) {
            mapView.removeRenderer(renderer);
        }
        SnapshotRenderer renderer = new SnapshotRenderer(location, distance);
        mapView.addRenderer((MapRenderer)renderer);
        mapMeta.setMapView(mapView);
        map.setItemMeta((ItemMeta)mapMeta);
    }

    public static Snapshot getLocationAndDirection(int id, boolean in) {
        int which = in ? 1 : 0;
        HashMap<String, Object> whered = new HashMap<String, Object>();
        whered.put("tardis_id", id);
        whered.put("door_type", which);
        ResultSetDoors rsd = new ResultSetDoors(TARDIS.plugin, whered, false);
        if (rsd.resultSet()) {
            COMPASS d = rsd.getDoor_direction();
            Location door = TARDISStaticLocationGetters.getLocationFromDB(rsd.getDoor_location());
            door.add(0.0, (double)1.6f, 0.0);
            int getx = door.getBlockX();
            int getz = door.getBlockZ();
            float yaw = switch (d) {
                case COMPASS.SOUTH -> {
                    door.setX((double)getx + 0.5);
                    door.setZ((double)getz - 0.5);
                    yield in ? 0.05f : 180.05f;
                }
                case COMPASS.WEST -> {
                    door.setX((double)getx + 1.5);
                    door.setZ((double)getz + 0.5);
                    yield in ? 90.05f : -90.05f;
                }
                case COMPASS.NORTH -> {
                    door.setX((double)getx + 0.5);
                    door.setZ((double)getz + 1.5);
                    yield in ? 180.05f : 0.05f;
                }
                default -> {
                    door.setX((double)getx - 0.5);
                    door.setZ((double)getz + 0.5);
                    yield in ? -90.05f : 90.05f;
                }
            };
            door.setPitch(0.0f);
            door.setYaw(yaw);
            return new Snapshot(door, d);
        }
        return null;
    }

    public static ItemFrame getItemFrameFromLocation(Location location, UUID uuid) {
        BoundingBox box = new BoundingBox((double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ(), (double)(location.getBlockX() + 1), (double)(location.getBlockY() + 1), (double)(location.getBlockZ() + 1));
        for (Entity e2 : location.getWorld().getNearbyEntities(box, e -> e.getType() == EntityType.ITEM_FRAME)) {
            ItemFrame frame;
            if (!(e2 instanceof ItemFrame) || (frame = (ItemFrame)e2).getUniqueId() == uuid) continue;
            return frame;
        }
        return null;
    }

    public static ItemFrame getItemFrameFromLocation(int id, boolean monitor) {
        Location location;
        int control = monitor ? 45 : 46;
        Material material = monitor ? Material.FILLED_MAP : Material.GLASS;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("type", control);
        ResultSetControls rsc = new ResultSetControls(TARDIS.plugin, where, false);
        if (rsc.resultSet() && (location = TARDISStaticLocationGetters.getLocationFromBukkitString(rsc.getLocation())) != null) {
            BoundingBox box = new BoundingBox((double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ(), (double)(location.getBlockX() + 1), (double)(location.getBlockY() + 1), (double)(location.getBlockZ() + 1));
            for (Entity e2 : location.getWorld().getNearbyEntities(box, e -> e.getType() == EntityType.ITEM_FRAME)) {
                ItemFrame frame;
                if (!(e2 instanceof ItemFrame) || (frame = (ItemFrame)e2).getItem().getType() != material) continue;
                return frame;
            }
        }
        return null;
    }
}

