/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners.controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.custommodels.keys.Whoniverse;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetProgram;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesProcessor;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesProgramInventory;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISHandlesFrameListener
implements Listener {
    private final TARDIS plugin;
    private final List<Integer> talkingHandles = new ArrayList<Integer>();

    public TARDISHandlesFrameListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onHandlesFrameClick(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            String l = frame.getLocation().toString();
            Player player = event.getPlayer();
            HashMap<String, Object> whereh = new HashMap<String, Object>();
            whereh.put("location", l);
            whereh.put("type", 26);
            ResultSetControls rsh = new ResultSetControls(this.plugin, whereh, false);
            if (rsh.resultSet()) {
                if (!TARDISPermission.hasPermission(player, "tardis.handles.use")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                    return;
                }
                ItemStack is = frame.getItem();
                if (this.isHandles(is)) {
                    if (!this.plugin.getTrackerKeeper().getHandlesRotation().contains(player.getUniqueId())) {
                        event.setCancelled(true);
                    }
                    Integer handlesId = rsh.getTardis_id();
                    this.talkingHandles.add(handlesId);
                    TARDISSounds.playTARDISSound(player, "handles", 5L);
                    ItemMeta im = is.getItemMeta();
                    im.setItemModel(Whoniverse.HANDLES_ON.getKey());
                    is.setItemMeta(im);
                    frame.setItem(is, false);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        this.talkingHandles.remove(handlesId);
                        im.setItemModel(Whoniverse.HANDLES_OFF.getKey());
                        is.setItemMeta(im);
                        frame.setItem(is, false);
                    }, 20L);
                    if (!TARDISPermission.hasPermission(player, "tardis.handles.program")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                        return;
                    }
                    if (player.isSneaking()) {
                        player.openInventory(new TARDISHandlesProgramInventory(this.plugin, 0).getInventory());
                    } else {
                        int pid;
                        ResultSetProgram rsp;
                        ItemMeta dim;
                        ItemStack disk = player.getInventory().getItemInMainHand();
                        if (disk.getType().equals((Object)Material.MUSIC_DISC_WARD) && disk.hasItemMeta() && (dim = disk.getItemMeta()).hasDisplayName() && ComponentUtils.stripColour(dim.displayName()).equals("Handles Program Disk") && (rsp = new ResultSetProgram(this.plugin, pid = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)dim.lore().get(1))))).resultSet()) {
                            new TARDISHandlesProcessor(this.plugin, rsp.getProgram(), player, pid).processDisk();
                            HashMap<String, Object> set = new HashMap<String, Object>();
                            set.put("checked", 0);
                            HashMap<String, Object> wherep = new HashMap<String, Object>();
                            wherep.put("program_id", pid);
                            this.plugin.getQueryFactory().doUpdate("programs", set, wherep);
                            player.getInventory().setItemInMainHand(null);
                        }
                    }
                }
            } else {
                ItemStack is = player.getInventory().getItemInMainHand();
                if (this.isHandles(is)) {
                    if (!TARDISPermission.hasPermission(player, "tardis.handles.use")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                        return;
                    }
                    if (!this.plugin.getUtils().inTARDISWorld(event.getPlayer())) {
                        this.plugin.getMessenger().handlesSend(player, "HANDLES_TARDIS");
                        event.setCancelled(true);
                        return;
                    }
                    ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
                    if (rst.fromUUID(player.getUniqueId().toString())) {
                        HashMap<String, Object> wherec = new HashMap<String, Object>();
                        wherec.put("tardis_id", rst.getTardisId());
                        wherec.put("type", 26);
                        ResultSetControls rsc = new ResultSetControls(this.plugin, wherec, false);
                        if (!rsc.resultSet()) {
                            String newLocation = frame.getLocation().toString();
                            this.plugin.getQueryFactory().insertControl(rst.getTardisId(), 26, newLocation, 0);
                        } else {
                            event.setCancelled(true);
                            this.plugin.getMessenger().send((CommandSender)event.getPlayer(), TardisModule.TARDIS, "HANDLES_PLACED");
                        }
                    } else {
                        this.plugin.getMessenger().handlesSend(player, "HANDLES_NO_COMMAND");
                        event.setCancelled(true);
                    }
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemFrameDamage(EntityDamageByEntityEvent event) {
        if (event.getEntityType().equals((Object)EntityType.ITEM_FRAME)) {
            ItemFrame frame = (ItemFrame)event.getEntity();
            ItemStack is = frame.getItem();
            Entity entity = event.getDamager();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (this.isHandles(is)) {
                    where = new HashMap<String, Object>();
                    where.put("type", 26);
                    where.put("location", frame.getLocation().toString());
                    ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
                    if (!rsc.resultSet()) {
                        return;
                    }
                    Integer handlesId = rsc.getTardis_id();
                    if (player.isSneaking()) {
                        this.talkingHandles.add(handlesId);
                        event.setCancelled(true);
                        TARDISSounds.playTARDISSound(player, "handles", 5L);
                        ItemMeta im = is.getItemMeta();
                        im.setItemModel(Whoniverse.HANDLES_ON.getKey());
                        is.setItemMeta(im);
                        frame.setItem(is, false);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            this.talkingHandles.remove(handlesId);
                            im.setItemModel(Whoniverse.HANDLES_OFF.getKey());
                            is.setItemMeta(im);
                            frame.setItem(is, false);
                        }, 40L);
                    } else {
                        if (this.talkingHandles.stream().anyMatch(id -> id.equals(handlesId))) {
                            event.setCancelled(true);
                            this.plugin.debug(String.format("Cancelling breaking handles ID %d because he is still talking", handlesId));
                            return;
                        }
                        ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
                        if (rst.fromUUID(player.getUniqueId().toString()) && rsc.getTardis_id() == rst.getTardisId()) {
                            HashMap<String, Object> wherec = new HashMap<String, Object>();
                            wherec.put("c_id", rsc.getC_id());
                            this.plugin.getQueryFactory().doDelete("controls", wherec);
                        } else {
                            event.setCancelled(true);
                        }
                    }
                } else if (this.plugin.getGeneralKeeper().getProtectBlockMap().containsKey(event.getEntity().getLocation().getBlock().getLocation().toString())) {
                    event.setCancelled(true);
                } else if (is.getType() == Material.FILLED_MAP) {
                    where = new HashMap();
                    where.put("type", 37);
                    where.put("location", frame.getLocation().toString());
                    ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
                    if (!rsc.resultSet()) {
                        return;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCANNER_MAP");
                }
            } else {
                event.setCancelled(true);
            }
        }
    }

    private boolean isHandles(ItemStack is) {
        if (is != null && is.getType().equals((Object)Material.BIRCH_BUTTON) && is.hasItemMeta()) {
            ItemMeta im = is.getItemMeta();
            return im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Handles");
        }
        return false;
    }
}

