/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISBuilderInstanceKeeper;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISBlockBreakListener
implements Listener {
    private final TARDIS plugin;

    public TARDISBlockBreakListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        String line2;
        String line1;
        Sign sign;
        SignSide front;
        String line0;
        HashMap<String, Object> where;
        Player player = event.getPlayer();
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            Block b = event.getBlock();
            String l = b.getLocation().toString();
            where = new HashMap<String, Object>();
            where.put("location", l);
            where.put("police_box", 1);
            ResultSetBlocks rsb = new ResultSetBlocks(this.plugin, where, false);
            if (rsb.resultSet()) {
                this.plugin.getMessenger().sendStatus(player, "TARDIS_BREAK");
                event.setCancelled(true);
                return;
            }
        }
        if (this.plugin.getTrackerKeeper().getZeroRoomOccupants().contains(player.getUniqueId())) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_ZERO");
            return;
        }
        Block block = event.getBlock();
        Material blockType = block.getType();
        if (player.getGameMode().equals((Object)GameMode.CREATIVE) && TARDISBuilderInstanceKeeper.getPrecious().contains(blockType)) {
            where = new HashMap();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTravellers rs = new ResultSetTravellers(this.plugin, where, false);
            if (rs.resultSet()) {
                HashMap<String, Object> wherep = new HashMap<String, Object>();
                String loc = block.getLocation().toString();
                wherep.put("location", loc);
                wherep.put("police_box", 0);
                this.plugin.getQueryFactory().doDelete("blocks", wherep);
                this.plugin.getGeneralKeeper().getProtectBlockMap().remove(loc);
            }
            return;
        }
        if (Tag.WALL_SIGNS.isTagged((Keyed)blockType) && this.isPresetSign(line0 = ComponentUtils.stripColour((front = (sign = (Sign)block.getState()).getSide(Side.FRONT)).line(0)), line1 = ComponentUtils.stripColour(front.line(1)), line2 = ComponentUtils.stripColour(front.line(2)))) {
            event.setCancelled(true);
            sign.update();
        }
        if (blockType == Material.BEACON) {
            Location loc = event.getBlock().getLocation();
            if (loc.getWorld().getName().startsWith("TARDIS")) {
                return;
            }
            String b = loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
            for (String r : this.plugin.getConfig().getConfigurationSection("rechargers").getKeys(false)) {
                if (!r.startsWith("rift")) continue;
                World w = TARDISAliasResolver.getWorldFromAlias(this.plugin.getConfig().getString("rechargers." + r + ".world"));
                int x = this.plugin.getConfig().getInt("rechargers." + r + ".x");
                int y = this.plugin.getConfig().getInt("rechargers." + r + ".y");
                int z = this.plugin.getConfig().getInt("rechargers." + r + ".z");
                String l = w.getName() + "," + x + "," + y + "," + z;
                if (!l.equals(b)) continue;
                event.setCancelled(true);
                if (player.getUniqueId().toString().equals(this.plugin.getConfig().getString("rechargers." + r + ".uuid"))) {
                    this.plugin.getConfig().set("rechargers." + r, null);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RIFT_REMOVED");
                    event.getBlock().setBlockData(TARDISConstants.AIR);
                    ItemStack rm = ItemStack.of((Material)Material.BEACON, (int)1);
                    ItemMeta im = rm.getItemMeta();
                    im.displayName((Component)ComponentUtils.toWhite("Rift Manipulator"));
                    rm.setItemMeta(im);
                    w.dropItem(loc, rm);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RIFT_PLAYER");
                break;
            }
        }
    }

    private boolean isPresetSign(String l0, String l1, String l2) {
        if (l0.equalsIgnoreCase("WEEPING") || l0.equalsIgnoreCase("$50,000")) {
            return this.plugin.getGeneralKeeper().getSign_lookup().containsKey(l0) && l1.equals(this.plugin.getGeneralKeeper().getSign_lookup().get(l0));
        }
        return this.plugin.getGeneralKeeper().getSign_lookup().containsKey(l1) && l2.equals(this.plugin.getGeneralKeeper().getSign_lookup().get(l1));
    }
}

