/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.Objects;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.move.TARDISDoorListener;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleGlideEvent;

public class ElytraListener
implements Listener {
    private final TARDIS plugin;

    public ElytraListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onElytraFlyInVortex(EntityToggleGlideEvent event) {
        if (!event.isGliding()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.isOp()) {
            return;
        }
        if (!this.plugin.getUtils().inTARDISWorld(player)) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("creation.create_worlds")) {
            return;
        }
        String world = player.getWorld().getName();
        if (!world.equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
            return;
        }
        event.setCancelled(true);
        ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
        if (rs.fromUUID(player.getUniqueId().toString())) {
            Location idl = TARDISDoorListener.getDoor(1, rs.getTardisId()).getL();
            player.teleport(idl);
        } else {
            Location respawn = player.getRespawnLocation();
            player.teleport(Objects.requireNonNullElseGet(respawn, () -> ((World)this.plugin.getServer().getWorlds().getFirst()).getSpawnLocation()));
        }
    }
}

