/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lazarus.disguise;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISDisguise;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISDisguiseTracker;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISPlayerDisguiser;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

public class TARDISDisguiser {
    private static final boolean nameVisible = false;
    private final Player player;
    private Object[] options;
    private EntityType entityType;
    private Entity entity;

    public TARDISDisguiser(Player player) {
        this.player = player;
    }

    public TARDISDisguiser(EntityType entityType, Player player) {
        this.entityType = entityType;
        this.player = player;
        this.options = null;
        this.createDisguise();
    }

    public TARDISDisguiser(EntityType entityType, Player player, Object[] options) {
        this.entityType = entityType;
        this.player = player;
        this.options = options;
        this.createDisguise();
    }

    public static void disguiseToPlayer(Player to, World world) {
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            TARDISDisguise disguise;
            Entity mob;
            if (p.getWorld() != world) continue;
            if (TARDISDisguiseTracker.DISGUISED_AS_PLAYER.contains(p.getUniqueId())) {
                TARDISPlayerDisguiser.disguiseToPlayer(p, to);
            }
            if (!TARDISDisguiseTracker.DISGUISED_AS_MOB.containsKey(p.getUniqueId()) || (mob = TARDISDisguise.createMobDisguise(disguise = TARDISDisguiseTracker.DISGUISED_AS_MOB.get(p.getUniqueId()), world)) == null) continue;
            TARDISDisguiser.setEntityLocationIdAndName(mob, p.getLocation(), p);
            ClientboundRemoveEntitiesPacket packetPlayOutEntityDestroy = new ClientboundRemoveEntitiesPacket(new int[]{p.getEntityId()});
            ServerLevel level = ((CraftWorld)world).getHandle();
            level.addFreshEntity(mob, CreatureSpawnEvent.SpawnReason.CUSTOM);
            ClientboundAddEntityPacket packetPlayOutSpawnLivingEntity = new ClientboundAddEntityPacket(mob, 0, mob.blockPosition());
            ClientboundSetEntityDataPacket packetPlayOutEntityMetadata = new ClientboundSetEntityDataPacket(mob.getId(), mob.getEntityData().getNonDefaultValues());
            ServerGamePacketListenerImpl connection = ((CraftPlayer)to).getHandle().connection;
            connection.send((Packet)packetPlayOutEntityDestroy);
            connection.send((Packet)packetPlayOutSpawnLivingEntity);
            connection.send((Packet)packetPlayOutEntityMetadata);
        }
    }

    public static void redisguise(Player player, World world) {
        TARDISDisguise disguise = TARDISDisguiseTracker.DISGUISED_AS_MOB.get(player.getUniqueId());
        Entity mob = TARDISDisguise.createMobDisguise(disguise, world);
        if (mob != null) {
            TARDISDisguiser.setEntityLocationIdAndName(mob, player.getLocation(), player);
            TARDISDisguiseTracker.DISGUISED_AS_MOB.put(player.getUniqueId(), new TARDISDisguise(disguise.entityType(), disguise.options()));
            ClientboundRemoveEntitiesPacket packetPlayOutEntityDestroy = new ClientboundRemoveEntitiesPacket(new int[]{player.getEntityId()});
            ClientboundAddEntityPacket packetPlayOutSpawnLivingEntity = new ClientboundAddEntityPacket(mob, 0, mob.blockPosition());
            ClientboundSetEntityDataPacket packetPlayOutEntityMetadata = new ClientboundSetEntityDataPacket(mob.getId(), mob.getEntityData().getNonDefaultValues());
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p == player || player.getWorld() != p.getWorld()) continue;
                ServerGamePacketListenerImpl connection = ((CraftPlayer)p).getHandle().connection;
                connection.send((Packet)packetPlayOutEntityDestroy);
                connection.send((Packet)packetPlayOutSpawnLivingEntity);
                connection.send((Packet)packetPlayOutEntityMetadata);
            }
        }
    }

    private static void setEntityLocationIdAndName(Entity entity, Location location, Player player) {
        entity.setPos(location.getX(), location.getY(), location.getZ());
        entity.setId(player.getEntityId());
        entity.setYRot(TARDISDisguiser.fixYaw(location.getYaw()));
        entity.setXRot(location.getPitch());
        Mob insentient = (Mob)entity;
        insentient.setNoAi(true);
    }

    private static float fixYaw(float yaw) {
        return yaw * 256.0f / 360.0f;
    }

    private void createDisguise() {
        if (this.entityType != null) {
            Location location = this.player.getLocation();
            TARDISDisguise disguise = new TARDISDisguise(this.entityType, this.options);
            this.entity = TARDISDisguise.createMobDisguise(disguise, location.getWorld());
            if (this.entity != null) {
                TARDISDisguiser.setEntityLocationIdAndName(this.entity, location, this.player);
            }
        }
    }

    public void removeDisguise() {
        if (TARDISDisguiseTracker.DISGUISED_AS_PLAYER.contains(this.player.getUniqueId())) {
            new TARDISPlayerDisguiser(this.player, this.player.getUniqueId());
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)TARDIS.plugin, () -> TARDISDisguiseTracker.DISGUISED_AS_PLAYER.remove(this.player.getUniqueId()), 5L);
        } else {
            TARDISDisguiseTracker.DISGUISED_AS_MOB.remove(this.player.getUniqueId());
            ClientboundRemoveEntitiesPacket packetPlayOutEntityDestroy = new ClientboundRemoveEntitiesPacket(new int[]{this.player.getEntityId()});
            ServerPlayer cp = ((CraftPlayer)this.player).getHandle();
            ClientboundAddEntityPacket packetPlayOutNamedEntitySpawn = new ClientboundAddEntityPacket((Entity)cp, 0, cp.blockPosition());
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p == this.player || this.player.getWorld() != p.getWorld()) continue;
                ServerGamePacketListenerImpl connection = ((CraftPlayer)p).getHandle().connection;
                connection.send((Packet)packetPlayOutEntityDestroy);
                connection.send((Packet)packetPlayOutNamedEntitySpawn);
            }
        }
    }

    public void disguiseToAll() {
        TARDISDisguiseTracker.DISGUISED_AS_MOB.put(this.player.getUniqueId(), new TARDISDisguise(this.entityType, this.options));
        ClientboundRemoveEntitiesPacket packetPlayOutEntityDestroy = new ClientboundRemoveEntitiesPacket(new int[]{this.player.getEntityId()});
        ClientboundAddEntityPacket packetPlayOutSpawnLivingEntity = new ClientboundAddEntityPacket(this.entity, 0, this.entity.blockPosition());
        ClientboundSetEntityDataPacket packetPlayOutEntityMetadata = new ClientboundSetEntityDataPacket(this.entity.getId(), this.entity.getEntityData().getNonDefaultValues());
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p == this.player || this.player.getWorld() != p.getWorld()) continue;
            ServerGamePacketListenerImpl connection = ((CraftPlayer)p).getHandle().connection;
            connection.send((Packet)packetPlayOutEntityDestroy);
            connection.send((Packet)packetPlayOutSpawnLivingEntity);
            connection.send((Packet)packetPlayOutEntityMetadata);
        }
    }
}

