/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lazarus.disguise;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISArmourStandDisguiser;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISDisguiseTracker;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISDisguiser;
import me.eccentric_nz.tardischunkgenerator.helpers.TARDISPacketListener;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class TARDISDisguiseListener
implements Listener {
    private final TARDIS plugin;

    public TARDISDisguiseListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerWorldChange(PlayerChangedWorldEvent event) {
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("LibsDisguises")) {
            Player player = event.getPlayer();
            World world = player.getWorld();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                if (TARDISDisguiseTracker.DISGUISED_AS_MOB.containsKey(player.getUniqueId())) {
                    TARDISDisguiser.redisguise(player, world);
                } else {
                    TARDISDisguiser.disguiseToPlayer(player, world);
                }
            }, 5L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("LibsDisguises")) {
            this.disguiseToPlayer(event.getPlayer(), event.getPlayer().getWorld());
        }
        TARDISPacketListener.injectPlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("LibsDisguises")) {
            this.disguiseToPlayer(event.getPlayer(), event.getPlayer().getWorld());
        }
    }

    private void disguiseToPlayer(Player player, World world) {
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("LibsDisguises")) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                TARDISDisguiser.disguiseToPlayer(player, world);
                TARDISArmourStandDisguiser.disguiseToPlayer(player, world);
            }, 5L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (!this.plugin.getServer().getPluginManager().isPluginEnabled("LibsDisguises")) {
            TARDISDisguiseTracker.DISGUISED_AS_MOB.remove(uuid);
            TARDISDisguiseTracker.DISGUISED_AS_PLAYER.remove(uuid);
            TARDISDisguiseTracker.ARCHED.remove(uuid);
        }
        TARDISPacketListener.removePlayer(event.getPlayer());
    }
}

