/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.info.processors;

import io.papermc.paper.dialog.Dialog;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.info.TARDISInfoMenu;
import me.eccentric_nz.TARDIS.info.TISCategory;
import me.eccentric_nz.TARDIS.info.dialog.EntryDialog;
import me.eccentric_nz.TARDIS.info.dialog.InfoDialog;
import me.eccentric_nz.TARDIS.info.dialog.RoomInfoDialog;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import org.bukkit.entity.Player;

public class SectionProcessor {
    private final TARDIS plugin;
    private final Player player;

    public SectionProcessor(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void showDialog(String entry) {
        Dialog dialog;
        TARDISInfoMenu tardisInfoMenu = TARDISInfoMenu.valueOf(entry);
        if (tardisInfoMenu.isRoom()) {
            dialog = new RoomInfoDialog().create(this.plugin, tardisInfoMenu);
        } else if (tardisInfoMenu.isSonicUpgrade()) {
            tardisInfoMenu = TARDISInfoMenu.valueOf(entry + "_INFO");
            dialog = new InfoDialog().create(this.plugin, tardisInfoMenu);
        } else if (tardisInfoMenu.isMonster() && tardisInfoMenu != TARDISInfoMenu.K9 || this.isInfoDirect(tardisInfoMenu)) {
            dialog = new InfoDialog().create(this.plugin, tardisInfoMenu);
        } else {
            TISCategory category = this.plugin.getTrackerKeeper().getInfoGUI().get(this.player.getUniqueId());
            dialog = new EntryDialog().create(tardisInfoMenu, category);
        }
        Audience.audience((Audience[])new Audience[]{this.player}).showDialog((DialogLike)dialog);
    }

    private boolean isInfoDirect(TARDISInfoMenu tardisInfoMenu) {
        return tardisInfoMenu.isConsole() || tardisInfoMenu.isConsoleBlock() || tardisInfoMenu.isTimeTravel() || tardisInfoMenu.isUpdateable();
    }
}

