/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.handles.wiki;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.dialog.DialogResponseView;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.body.PlainMessageDialogBody;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.handles.wiki.SearchDialog;
import me.eccentric_nz.TARDIS.handles.wiki.WikiLink;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.entity.Player;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HandlesWikiDialogProcessor {
    private final TARDIS plugin;

    public HandlesWikiDialogProcessor(TARDIS plugin) {
        this.plugin = plugin;
    }

    private static Set<WikiLink> getWikiLinks(DialogResponseView response) {
        String query = response.getText("search");
        HashSet<WikiLink> results = new HashSet<WikiLink>();
        if (query != null) {
            Pattern pattern = Pattern.compile(query, 2);
            try {
                Document doc = Jsoup.connect((String)"https://tardis.pages.dev/site-map").get();
                Elements links = doc.select("a");
                for (Element e : links) {
                    String linkHref = e.attr("href");
                    String linkText = e.text();
                    Matcher mat = pattern.matcher(linkText);
                    if (!mat.find()) continue;
                    results.add(new WikiLink(linkText, linkHref));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return results;
    }

    public void getLinks(DialogResponseView response, Player player) {
        Set<WikiLink> results = HandlesWikiDialogProcessor.getWikiLinks(response);
        ArrayList<ActionButton> actions = new ArrayList<ActionButton>();
        if (!results.isEmpty()) {
            for (WikiLink w : results) {
                try {
                    URI uri = URI.create(w.getURL());
                    DialogAction.StaticAction action = DialogAction.staticAction((ClickEvent)ClickEvent.openUrl((URL)uri.toURL()));
                    ActionButton button = ActionButton.create((Component)Component.text((String)w.getTitle()), null, (int)150, (DialogAction)action);
                    actions.add(button);
                }
                catch (MalformedURLException uri) {}
            }
        } else {
            DialogAction.StaticAction action = DialogAction.staticAction((ClickEvent)ClickEvent.callback(audience -> audience.showDialog((DialogLike)new SearchDialog().create())));
            ActionButton yesButton = ActionButton.create((Component)Component.text((String)"No results"), null, (int)150, (DialogAction)action);
            actions.add(yesButton);
        }
        List<PlainMessageDialogBody> body = List.of(DialogBody.plainMessage((Component)Component.text((String)"Search results:"), (int)200));
        DialogBase dialogData = DialogBase.create((Component)Component.text((String)"TARDIS Wiki"), null, (boolean)true, (boolean)true, (DialogBase.DialogAfterAction)DialogBase.DialogAfterAction.CLOSE, body, List.of());
        DialogAction.StaticAction action = DialogAction.staticAction((ClickEvent)ClickEvent.callback(audience -> audience.showDialog((DialogLike)new SearchDialog().create())));
        ActionButton yesButton = ActionButton.create((Component)Component.text((String)"Back"), null, (int)150, (DialogAction)action);
        Dialog dialog = Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(dialogData).type((DialogType)DialogType.multiAction((List)actions, (ActionButton)yesButton, (int)1)));
        Audience receiver = Audience.audience((Audience[])new Audience[]{player});
        receiver.showDialog((DialogLike)dialog);
    }
}

