/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight.vehicle;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import java.util.Map;
import me.eccentric_nz.tardisweepingangels.nms.EntityRegistry;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class TARDISArmourStand
extends ArmorStand {
    private static final String entityId = "flight_vehicle";
    private Player player = null;
    private boolean stationary = false;
    private double speedFactor = 3.0;

    public TARDISArmourStand(EntityType<? extends ArmorStand> entityType, Level world) {
        super(EntityType.ARMOR_STAND, world);
        this.setNoGravity(false);
        this.setInvisible(true);
        this.setInvulnerable(true);
        this.persist = true;
    }

    public static void injectEntity(Identifier mcKey) throws NoSuchFieldException, IllegalAccessException {
        Registry entityReg = (Registry)((CraftServer)Bukkit.getServer()).getServer().registryAccess().lookup(Registries.ENTITY_TYPE).orElseThrow(NoSuchFieldException::new);
        EntityRegistry.unfreeze();
        Map types = DataFixers.getDataFixer().getSchema(DataFixUtils.makeKey((int)SharedConstants.getCurrentVersion().dataVersion().version())).findChoiceType(References.ENTITY).types();
        types.put(mcKey.toString(), (Type)types.get(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ARMOR_STAND).toString()));
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)Identifier.withDefaultNamespace((String)entityId));
        EntityType type = EntityType.Builder.of(TARDISArmourStand::new, (MobCategory)MobCategory.MISC).noSummon().build(resourceKey);
        entityReg.createIntrusiveHolder((Object)type);
        Registry.register((Registry)entityReg, (String)entityId, (Object)type);
    }

    public void travel(Vec3 vec3d) {
        if (super.isNoGravity()) {
            super.travel(vec3d);
        } else {
            Vector direction = this.player == null || this.stationary || this.onGround() && this.player.getLocation().getDirection().getY() < 0.0 ? new Vector(0, 0, 0) : this.player.getLocation().getDirection();
            this.move(MoverType.SELF, new Vec3(direction.getX() / this.speedFactor, direction.getY() / this.speedFactor, direction.getZ() / this.speedFactor));
        }
    }

    public void addAdditionalSaveData(ValueOutput nbttagcompound) {
        super.addAdditionalSaveData(nbttagcompound);
        nbttagcompound.putString("id", "minecraft:flight_vehicle");
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isStationary() {
        return this.stationary;
    }

    public void setStationary(boolean stationary) {
        this.stationary = stationary;
    }

    public double getSpeedFactor() {
        return this.speedFactor;
    }

    public void setSpeedFactor(double speedFactor) {
        this.speedFactor = speedFactor;
    }
}

