/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.flight.TARDISFlightAdjustment;
import me.eccentric_nz.TARDIS.flight.TARDISRegulatorInventory;
import me.eccentric_nz.TARDIS.flight.TARDISRegulatorRunnable;
import me.eccentric_nz.TARDIS.flight.TARDISRegulatorSlot;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;

public class TARDISRegulatorListener
extends TARDISRegulatorSlot
implements Listener {
    private final TARDIS plugin;
    private final List<Integer> directions = List.of(Integer.valueOf(16), Integer.valueOf(24), Integer.valueOf(26), Integer.valueOf(34));

    public TARDISRegulatorListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onHelmicRegulatorClose(InventoryCloseEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISRegulatorInventory)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.plugin.getTrackerKeeper().getRegulating().containsKey(uuid)) {
            this.plugin.getServer().getScheduler().cancelTask(this.plugin.getTrackerKeeper().getRegulating().get(uuid).getTaskId());
            this.plugin.getTrackerKeeper().getRegulating().remove(uuid);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HELMIC_ABORT");
            Location adjusted = new TARDISFlightAdjustment(this.plugin).getLocation(this.plugin.getTrackerKeeper().getFlightData().get(uuid), 10);
            this.plugin.getTrackerKeeper().getFlightData().get(uuid).setLocation(adjusted);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHelmicRegulatorOpen(InventoryOpenEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISRegulatorInventory)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        UUID uuid = player.getUniqueId();
        TARDISRegulatorRunnable wr = new TARDISRegulatorRunnable(event.getView());
        int id = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)wr, 5L, 20L);
        wr.setTaskId(id);
        this.plugin.getTrackerKeeper().getRegulating().put(uuid, wr);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            this.plugin.getServer().getScheduler().cancelTask(id);
            int final_slot = this.plugin.getTrackerKeeper().getRegulating().get(uuid).getSlot();
            this.plugin.getTrackerKeeper().getRegulating().remove(uuid);
            player.closeInventory();
            int blocks = 0;
            switch (final_slot) {
                case 0: 
                case 4: 
                case 36: 
                case 40: {
                    blocks = 8;
                    break;
                }
                case 1: 
                case 3: 
                case 9: 
                case 13: 
                case 27: 
                case 31: 
                case 37: 
                case 39: {
                    blocks = 6;
                    break;
                }
                case 2: 
                case 10: 
                case 12: 
                case 18: 
                case 22: 
                case 28: 
                case 30: 
                case 38: {
                    blocks = 4;
                    break;
                }
                case 11: 
                case 19: 
                case 21: 
                case 29: {
                    blocks = 2;
                    break;
                }
            }
            if (blocks != 0) {
                Location adjusted = new TARDISFlightAdjustment(this.plugin).getLocation(this.plugin.getTrackerKeeper().getFlightData().get(uuid), blocks);
                this.plugin.getTrackerKeeper().getFlightData().get(uuid).setLocation(adjusted);
            }
        }, 600L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onHelmicRegulatorClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISRegulatorInventory)) {
            return;
        }
        UUID uuid = event.getWhoClicked().getUniqueId();
        if (this.plugin.getTrackerKeeper().getRegulating().containsKey(uuid)) {
            int slot = event.getRawSlot();
            int old_slot = this.plugin.getTrackerKeeper().getRegulating().get(uuid).getSlot();
            if (this.directions.contains(slot)) {
                InventoryView view = event.getView();
                switch (slot) {
                    case 16: {
                        int up = this.upSlot(old_slot);
                        if (!this.bounds.contains(up)) break;
                        view.setItem(old_slot, this.vortex);
                        view.setItem(up, this.box);
                        this.plugin.getTrackerKeeper().getRegulating().get(uuid).setSlot(up);
                        break;
                    }
                    case 24: {
                        int left = this.leftSlot(old_slot);
                        if (!this.bounds.contains(left)) break;
                        view.setItem(old_slot, this.vortex);
                        view.setItem(left, this.box);
                        this.plugin.getTrackerKeeper().getRegulating().get(uuid).setSlot(left);
                        break;
                    }
                    case 26: {
                        int right = this.rightSlot(old_slot);
                        if (!this.bounds.contains(right)) break;
                        view.setItem(old_slot, this.vortex);
                        view.setItem(right, this.box);
                        this.plugin.getTrackerKeeper().getRegulating().get(uuid).setSlot(right);
                        break;
                    }
                    case 34: {
                        int down = this.downSlot(old_slot);
                        if (!this.bounds.contains(down)) break;
                        view.setItem(old_slot, this.vortex);
                        view.setItem(down, this.box);
                        this.plugin.getTrackerKeeper().getRegulating().get(uuid).setSlot(down);
                        break;
                    }
                }
            }
            event.setCancelled(true);
        }
    }
}

