/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitDamager;
import me.eccentric_nz.TARDIS.artron.TARDISArtronLevels;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.utility.TARDISSculkShrieker;
import me.eccentric_nz.TARDIS.camera.TARDISCameraTracker;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetJunk;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetThrottle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.flight.TARDISExteriorFlight;
import me.eccentric_nz.TARDIS.flight.TARDISHandbrake;
import me.eccentric_nz.TARDIS.flight.TARDISTakeoff;
import me.eccentric_nz.TARDIS.flight.vehicle.VehicleUtility;
import me.eccentric_nz.TARDIS.rotors.Rotor;
import me.eccentric_nz.TARDIS.rotors.TARDISTimeRotor;
import me.eccentric_nz.TARDIS.sensor.BeaconSensor;
import me.eccentric_nz.TARDIS.sensor.HandbrakeSensor;
import me.eccentric_nz.TARDIS.utility.Handbrake;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class TARDISHandbrakeListener
implements Listener {
    private final TARDIS plugin;

    public TARDISHandbrakeListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Material blockType;
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block != null && (blockType = block.getType()) == Material.LEVER) {
            UUID uuid = player.getUniqueId();
            HashMap<String, Object> whereu = new HashMap<String, Object>();
            whereu.put("uuid", uuid.toString());
            ResultSetTravellers rsv = new ResultSetTravellers(this.plugin, whereu, false);
            boolean inside = rsv.resultSet();
            Location handbrake_loc = block.getLocation();
            HashMap<String, Object> where = new HashMap<String, Object>();
            boolean found = false;
            int tmp_id = -1;
            if (inside) {
                where.put("type", 0);
                where.put("location", handbrake_loc.toString());
                ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
                if (rsc.resultSet()) {
                    found = true;
                    tmp_id = rsc.getTardis_id();
                }
            } else {
                where.put("uuid", uuid.toString());
                where.put("handbrake", handbrake_loc.toString());
                ResultSetJunk rsj = new ResultSetJunk(this.plugin, where);
                if (rsj.resultSet()) {
                    found = true;
                    tmp_id = rsj.getTardis_id();
                }
            }
            if (found) {
                event.setCancelled(true);
                int id = tmp_id;
                TARDISCircuitChecker tcc = new TARDISCircuitChecker(this.plugin, id);
                tcc.getCircuits();
                if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) && !tcc.hasMaterialisation()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MAT_CIRCUIT");
                    return;
                }
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                    return;
                }
                HashMap<String, Object> wherei = new HashMap<String, Object>();
                wherei.put("tardis_id", id);
                ResultSetTardis rs = new ResultSetTardis(this.plugin, wherei, "", false);
                if (rs.resultSet()) {
                    Tardis tardis = rs.getTardis();
                    ChameleonPreset preset = tardis.getPreset();
                    if (preset.equals((Object)ChameleonPreset.JUNK)) {
                        return;
                    }
                    UUID ownerUUID = tardis.getUuid();
                    if (tardis.isIsomorphicOn() && !uuid.equals(ownerUUID) && event.useInteractedBlock().equals((Object)Event.Result.DENY) && !TARDISPermission.hasPermission(player, "tardis.skeletonkey") || this.plugin.getTrackerKeeper().getJohnSmith().containsKey(uuid)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ISO_HANDS_OFF");
                        return;
                    }
                    if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                        return;
                    }
                    String beacon = tardis.getBeacon();
                    if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getDidDematToVortex().contains(id) || this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                        this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_IN_VORTEX");
                    } else {
                        Action action = event.getAction();
                        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
                        boolean beac_on = true;
                        boolean bar = false;
                        Throticle throticle = new ResultSetThrottle(this.plugin).getSpeedAndParticles(uuid.toString());
                        if (rsp.resultSet()) {
                            beac_on = rsp.isBeaconOn();
                            bar = rsp.isTravelbarOn();
                        }
                        if (action == Action.RIGHT_CLICK_BLOCK) {
                            if (tardis.isHandbrakeOn()) {
                                if (preset.equals((Object)ChameleonPreset.JUNK_MODE) && !this.plugin.getTrackerKeeper().getHasDestination().containsKey(id)) {
                                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NEED_DEST");
                                    return;
                                }
                                if (!this.plugin.getTrackerKeeper().getHasDestination().containsKey(id) && tardis.getArtronLevel() < this.plugin.getArtronConfig().getInt("random")) {
                                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NOT_ENOUGH");
                                    return;
                                }
                                Handbrake check = new Handbrake(this.plugin);
                                if (check.isDoorOpen(id)) {
                                    this.plugin.getMessenger().sendStatus(player, "DOOR_CLOSE");
                                    this.plugin.getTrackerKeeper().getHasClickedHandbrake().add(id);
                                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getTrackerKeeper().getHasClickedHandbrake().removeAll(Collections.singleton(id)), 600L);
                                    return;
                                }
                                if (check.isRelativityDifferentiated(id) && TARDISPermission.hasPermission(player, "tardis.fly") && preset.usesArmourStand() && !player.isSneaking()) {
                                    ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                                    if (!rsc.resultSet()) {
                                        this.plugin.debug("No current location");
                                        return;
                                    }
                                    Current current = rsc.getCurrent();
                                    for (int y = current.location().getBlockY() + 4; y < current.location().getBlockY() + 8; ++y) {
                                        if (current.location().getWorld().getBlockAt(current.location().getBlockX(), y, current.location().getBlockZ()).getType().isAir()) continue;
                                        this.plugin.getMessenger().sendStatus(player, "FLIGHT_AIR");
                                        return;
                                    }
                                    if (TARDISCameraTracker.CAMERA_IN_USE.contains(id)) {
                                        this.plugin.getMessenger().sendStatus(player, "FLIGHT_CAMERA");
                                        return;
                                    }
                                    if (!preset.usesArmourStand()) {
                                        this.plugin.getMessenger().sendStatus(player, "FLIGHT_PRESET");
                                        return;
                                    }
                                    Location exterior = current.location().clone();
                                    exterior.setYaw(player.getLocation().getYaw());
                                    exterior.setPitch(player.getLocation().getPitch());
                                    if (VehicleUtility.isNotFlightReady(exterior)) {
                                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "FLIGHT_REBUILD");
                                        return;
                                    }
                                    new TARDISExteriorFlight(this.plugin).startFlying(player, id, block, exterior, beac_on, beacon);
                                } else {
                                    new TARDISTakeoff(this.plugin).run(id, block, handbrake_loc, player, beac_on, beacon, bar, throticle);
                                }
                                if (tardis.getRotor() != null) {
                                    if (tardis.getRotor() == TARDISConstants.UUID_ZERO) {
                                        TARDISSculkShrieker.setRotor(id);
                                    } else {
                                        ItemFrame itemFrame = TARDISTimeRotor.getItemFrame(tardis.getRotor());
                                        if (itemFrame != null) {
                                            Rotor rotor = Rotor.getByModel(TARDISTimeRotor.getRotorModel(itemFrame));
                                            TARDISTimeRotor.setRotor(rotor, itemFrame);
                                        }
                                    }
                                }
                            } else {
                                this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_OFF_ERR");
                            }
                        }
                        if (action == Action.LEFT_CLICK_BLOCK) {
                            if (!tardis.isHandbrakeOn()) {
                                if (tardis.getRotor() != null) {
                                    if (tardis.getRotor() == TARDISConstants.UUID_ZERO) {
                                        TARDISSculkShrieker.stopRotor(id);
                                    } else {
                                        ItemFrame itemFrame = TARDISTimeRotor.getItemFrame(tardis.getRotor());
                                        if (itemFrame != null) {
                                            int task = TARDISTimeRotor.ANIMATED_ROTORS.getOrDefault(itemFrame.getUniqueId(), -1);
                                            this.plugin.getServer().getScheduler().cancelTask(task);
                                            TARDISTimeRotor.setRotor(TARDISTimeRotor.getRotorOffModel(itemFrame), itemFrame);
                                        }
                                    }
                                }
                                Optional.ofNullable(this.plugin.getTrackerKeeper().getFlyingReturnLocation().get(uuid)).ifPresent(value -> {
                                    player.stopAllSounds();
                                    if (value.sound() != -1) {
                                        this.plugin.getServer().getScheduler().cancelTask(value.sound());
                                    }
                                    this.plugin.getTrackerKeeper().getFlyingReturnLocation().remove(uuid);
                                });
                                TARDISSounds.playTARDISSound(handbrake_loc, "tardis_handbrake_engage");
                                TARDISHandbrake.setLevers(block, true, inside, handbrake_loc.toString(), id, this.plugin);
                                new TARDISArtronLevels(this.plugin).recharge(id);
                                if (!beac_on && !beacon.isEmpty()) {
                                    new BeaconSensor().toggle(beacon, false);
                                }
                                new HandbrakeSensor(this.plugin, id).toggle();
                                this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_ON");
                                if (this.plugin.getTrackerKeeper().getHasDestination().containsKey(id)) {
                                    Player ptl;
                                    int amount = Math.round((float)this.plugin.getTrackerKeeper().getHasDestination().get(id).cost() * throticle.throttle().getArtronMultiplier());
                                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                                    wheret.put("tardis_id", id);
                                    this.plugin.getQueryFactory().alterEnergyLevel("tardis", -amount, wheret, player);
                                    if (!uuid.equals(ownerUUID) && (ptl = this.plugin.getServer().getPlayer(ownerUUID)) != null) {
                                        this.plugin.getMessenger().sendArtron(ptl, id, Math.abs(amount));
                                    }
                                }
                                this.plugin.getTrackerKeeper().getHasDestination().remove(id);
                                if (this.plugin.getTrackerKeeper().getHasRandomised().contains(id)) {
                                    this.plugin.getTrackerKeeper().getHasRandomised().removeAll(Collections.singleton(id));
                                }
                                if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.materialisation") > 0) {
                                    int uses_left = tcc.getMaterialisationUses();
                                    new TARDISCircuitDamager(this.plugin, DiskCircuit.MATERIALISATION, uses_left, id, player).damage();
                                }
                                HashMap<String, Object> set = new HashMap<String, Object>();
                                set.put("handbrake_on", 1);
                                HashMap<String, Object> whereh = new HashMap<String, Object>();
                                whereh.put("tardis_id", id);
                                this.plugin.getQueryFactory().doUpdate("tardis", set, whereh);
                            } else {
                                this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_ON_ERR");
                            }
                        }
                    }
                }
            }
        }
    }
}

