/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.GameRuleConverter;
import me.eccentric_nz.tardischunkgenerator.helpers.TARDISPlanetData;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class TARDISPlanetsUpdater {
    private final TARDIS plugin;
    private final FileConfiguration planets_config;

    public TARDISPlanetsUpdater(TARDIS plugin, FileConfiguration planets_config) {
        this.plugin = plugin;
        this.planets_config = planets_config;
    }

    public void checkPlanetsConfig() {
        int save = 0;
        String dn = this.plugin.getConfig().getString("creation.default_world_name");
        if (this.plugin.getConfig().contains("worlds")) {
            for (Object w : this.plugin.getConfig().getConfigurationSection("worlds").getKeys(false)) {
                if (this.planets_config.contains("planets." + (String)w)) continue;
                TARDISPlanetData data = this.plugin.getTardisHelper().getLevelData((String)w);
                this.planets_config.set("planets." + w + ".enabled", (Object)true);
                this.planets_config.set("planets." + w + ".time_travel", (Object)this.plugin.getConfig().getBoolean("worlds." + w));
                this.planets_config.set("planets." + w + ".resource_pack", (Object)"default");
                this.planets_config.set("planets." + w + ".gamemode", (Object)data.gameMode().toString());
                this.planets_config.set("planets." + w + ".world_type", (Object)data.worldType().toString());
                this.planets_config.set("planets." + w + ".environment", (Object)data.environment().toString());
                this.planets_config.set("planets." + w + ".difficulty", (Object)data.difficulty().toString());
                if (((String)w).startsWith("TARDIS_") || ((String)w).equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
                    this.planets_config.set("planets." + w + ".generator", (Object)"TARDIS:void");
                    continue;
                }
                this.planets_config.set("planets." + w + ".generator", (Object)"DEFAULT");
            }
            this.plugin.getConfig().set("worlds", null);
            this.plugin.saveConfig();
            if (!this.planets_config.contains("planets.TARDIS_Zero_Room")) {
                this.planets_config.set("planets.TARDIS_Zero_Room.enabled", (Object)false);
                this.planets_config.set("planets.TARDIS_Zero_Room.time_travel", (Object)false);
                this.planets_config.set("planets.TARDIS_Zero_Room.resource_pack", (Object)"default");
                this.planets_config.set("planets.TARDIS_Zero_Room.gamemode", (Object)this.plugin.getConfig().getString("creation.gamemode").toUpperCase(Locale.ROOT));
                this.planets_config.set("planets.TARDIS_Zero_Room.world_type", (Object)"FLAT");
                this.planets_config.set("planets.TARDIS_Zero_Room.environment", (Object)"NORMAL");
                this.planets_config.set("planets.TARDIS_Zero_Room.difficulty", (Object)"NORMAL");
                this.planets_config.set("planets.TARDIS_Zero_Room.generator", (Object)"TARDIS:void");
                this.planets_config.set("planets.TARDIS_Zero_Room.void", (Object)true);
                this.planets_config.set("planets.TARDIS_Zero_Room.gamerules.advance_weather", (Object)false);
                this.planets_config.set("planets.TARDIS_Zero_Room.gamerules.advance_time", (Object)false);
                this.planets_config.set("planets.TARDIS_Zero_Room.gamerules.show_advancement_messages", (Object)false);
                this.planets_config.set("planets.TARDIS_Zero_Room.gamerules.spawn_wardens", (Object)false);
                this.planets_config.set("planets.TARDIS_Zero_Room.allow_portals", (Object)false);
                this.planets_config.set("planets.TARDIS_Zero_Room.alias", (Object)"ZeroRoom");
                this.planets_config.set("planets.TARDIS_Zero_Room.icon", (Object)"PINK_WOOL");
                this.planets_config.set("planets.TARDIS_Zero_Room.helmic_regulator_order", (Object)-1);
                ++save;
            }
            this.planets_config.set("planets." + dn + ".enabled", (Object)true);
            this.planets_config.set("planets." + dn + ".time_travel", (Object)false);
            this.planets_config.set("planets." + dn + ".resource_pack", (Object)"default");
            this.planets_config.set("planets." + dn + ".gamemode", (Object)this.plugin.getConfig().getString("creation.gamemode").toUpperCase(Locale.ROOT));
            this.planets_config.set("planets." + dn + ".world_type", (Object)"FLAT");
            this.planets_config.set("planets." + dn + ".environment", (Object)"NORMAL");
            this.planets_config.set("planets." + dn + ".difficulty", (Object)"NORMAL");
            this.planets_config.set("planets." + dn + ".generator", (Object)"TARDIS:void");
            this.planets_config.set("planets." + dn + ".void", (Object)true);
            this.planets_config.set("planets." + dn + ".gamerules.advance_weather", (Object)false);
            this.planets_config.set("planets." + dn + ".gamerules.advance_time", (Object)false);
            this.planets_config.set("planets." + dn + ".allow_portals", (Object)false);
            this.planets_config.set("planets." + dn + ".alias", (Object)"TimeVortex");
            this.planets_config.set("planets." + dn + ".icon", (Object)"CRYING_OBSIDIAN");
            this.planets_config.set("planets." + dn + ".helmic_regulator_order", (Object)-1);
            ++save;
        }
        if (!this.planets_config.contains("colour_skies")) {
            this.planets_config.set("colour_skies", (Object)true);
            ++save;
        }
        Set worlds = this.planets_config.getConfigurationSection("planets").getKeys(false);
        for (Object w : worlds) {
            if (this.planets_config.contains("planets." + (String)w + ".spawn_chunk_radius")) {
                this.planets_config.set("planets." + (String)w + ".spawn_chunk_radius", null);
            }
            if (!this.planets_config.contains("planets." + (String)w + ".keep_spawn_in_memory")) continue;
            this.planets_config.set("planets." + (String)w + ".keep_spawn_in_memory", null);
        }
        for (Object w : worlds) {
            if (this.planets_config.contains("planets." + (String)w + ".gamemode")) continue;
            TARDISPlanetData data = this.plugin.getTardisHelper().getLevelData((String)w);
            this.planets_config.set("planets." + w + ".gamemode", (Object)data.gameMode().toString());
            ++save;
        }
        for (Object w : worlds) {
            if (this.planets_config.contains("planets." + (String)w + ".alias")) continue;
            if (((String)w).equals("TARDIS_TimeVortex")) {
                this.planets_config.set("planets." + w + ".alias", (Object)"TimeVortex");
                continue;
            }
            if (((String)w).endsWith("TARDIS_Zero_Room")) {
                this.planets_config.set("planets." + w + ".alias", (Object)"ZeroRoom");
                continue;
            }
            if (((String)w).toLowerCase(Locale.ROOT).endsWith("gallifrey")) {
                this.planets_config.set("planets." + w + ".alias", (Object)"Gallifrey");
                continue;
            }
            if (((String)w).toLowerCase(Locale.ROOT).endsWith("siluria")) {
                this.planets_config.set("planets." + w + ".alias", (Object)"Siluria");
                continue;
            }
            if (((String)w).toLowerCase(Locale.ROOT).endsWith("skaro")) {
                this.planets_config.set("planets." + w + ".alias", (Object)"Skaro");
                continue;
            }
            if (((String)w).endsWith("_the_end")) {
                this.planets_config.set("planets." + w + ".alias", (Object)"TheEnd");
                continue;
            }
            if (((String)w).endsWith("_nether")) {
                this.planets_config.set("planets." + w + ".alias", (Object)"TheNether");
                continue;
            }
            this.planets_config.set("planets." + w + ".alias", w);
        }
        String d = this.getDifficulty();
        for (Object w : worlds) {
            if (this.planets_config.contains("planets." + (String)w + ".difficulty")) continue;
            this.planets_config.set("planets." + (String)w + ".difficulty", (Object)d);
        }
        for (Object w : worlds) {
            if (this.planets_config.contains("planets." + (String)w + ".icon")) continue;
            this.planets_config.set("planets." + (String)w + ".icon", (Object)this.getIcon((String)w, this.planets_config.getString("planets." + (String)w + ".environment")));
        }
        for (Object w : worlds) {
            if (this.planets_config.contains("planets." + (String)w + ".helmic_regulator_order")) continue;
            this.planets_config.set("planets." + (String)w + ".helmic_regulator_order", (Object)-1);
            ++save;
        }
        if (this.planets_config.contains("default_resource_pack") && this.planets_config.getString("default_resource_pack").equalsIgnoreCase("https://dl.dropboxusercontent.com/u/53758864/rp/Default.zip")) {
            this.planets_config.set("default_resource_pack", (Object)"https://www.dropbox.com/s/utka3zxmer7f19g/Default.zip?dl=1");
            ++save;
        }
        for (Object w : worlds) {
            if (this.planets_config.contains("planets." + (String)w + ".allow_portals")) continue;
            this.planets_config.set("planets." + (String)w + ".allow_portals", (Object)true);
            ++save;
        }
        if (!this.planets_config.contains("planets.gallifrey")) {
            this.planets_config.set("planets.skaro.enabled", (Object)false);
            this.planets_config.set("planets.skaro.resource_pack", (Object)"default");
            this.planets_config.set("planets.skaro.acid", (Object)true);
            this.planets_config.set("planets.skaro.acid_damage", (Object)5);
            this.planets_config.set("planets.skaro.acid_potions", List.of("WEAKNESS", "POISON"));
            this.planets_config.set("planets.skaro.rust", (Object)true);
            this.planets_config.set("planets.skaro.flying_daleks", (Object)true);
            this.planets_config.set("planets.skaro.gamemode", (Object)"SURVIVAL");
            this.planets_config.set("planets.skaro.time_travel", (Object)true);
            this.planets_config.set("planets.skaro.world_type", (Object)"NORMAL");
            this.planets_config.set("planets.skaro.environment", (Object)"NORMAL");
            this.planets_config.set("planets.skaro.generator", (Object)"TARDIS:skaro");
            this.planets_config.set("planets.skaro.spawn_chunk_radius", (Object)0);
            this.planets_config.set("planets.skaro.spawn_other_mobs", (Object)true);
            this.planets_config.set("planets.skaro.gamerules.spawn_wandering_traders", (Object)false);
            this.planets_config.set("planets.skaro.gamerules.spawn_patrols", (Object)false);
            this.planets_config.set("planets.skaro.allow_portals", (Object)false);
            this.planets_config.set("planets.skaro.alias", (Object)"Skaro");
            this.planets_config.set("planets.skaro.icon", (Object)"FIRE_CORAL_BLOCK");
            this.planets_config.set("planets.skaro.helmic_regulator_order", (Object)-1);
            this.planets_config.set("planets.siluria.enabled", (Object)false);
            this.planets_config.set("planets.siluria.resource_pack", (Object)"default");
            this.planets_config.set("planets.siluria.gamemode", (Object)"SURVIVAL");
            this.planets_config.set("planets.siluria.time_travel", (Object)true);
            this.planets_config.set("planets.siluria.world_type", (Object)"NORMAL");
            this.planets_config.set("planets.siluria.environment", (Object)"NORMAL");
            this.planets_config.set("planets.siluria.generator", (Object)"TARDIS:siluria");
            this.planets_config.set("planets.siluria.spawn_chunk_radius", (Object)0);
            this.planets_config.set("planets.siluria.spawn_other_mobs", (Object)true);
            this.planets_config.set("planets.siluria.gamerules.spawn_wandering_traders", (Object)false);
            this.planets_config.set("planets.siluria.gamerules.spawn_patrols", (Object)false);
            this.planets_config.set("planets.siluria.allow_portals", (Object)false);
            this.planets_config.set("planets.siluria.alias", (Object)"Siluria");
            this.planets_config.set("planets.siluria.icon", (Object)"BAMBOO_MOSAIC");
            this.planets_config.set("planets.siluria.helmic_regulator_order", (Object)-1);
            this.planets_config.set("planets.gallifrey.enabled", (Object)false);
            this.planets_config.set("planets.gallifrey.resource_pack", (Object)"default");
            this.planets_config.set("planets.gallifrey.gamemode", (Object)"SURVIVAL");
            this.planets_config.set("planets.gallifrey.time_travel", (Object)true);
            this.planets_config.set("planets.gallifrey.world_type", (Object)"NORMAL");
            this.planets_config.set("planets.gallifrey.environment", (Object)"NORMAL");
            this.planets_config.set("planets.gallifrey.generator", (Object)"TARDIS:gallifrey");
            this.planets_config.set("planets.gallifrey.spawn_chunk_radius", (Object)0);
            this.planets_config.set("planets.gallifrey.spawn_other_mobs", (Object)true);
            this.planets_config.set("planets.gallifrey.gamerules.spawn_wandering_traders", (Object)false);
            this.planets_config.set("planets.gallifrey.gamerules.spawn_patrols", (Object)false);
            this.planets_config.set("planets.gallifrey.allow_portals", (Object)false);
            this.planets_config.set("planets.gallifrey.alias", (Object)"Gallifrey");
            this.planets_config.set("planets.gallifrey.icon", (Object)"RED_SAND");
            this.planets_config.set("planets.gallifrey.helmic_regulator_order", (Object)-1);
            this.planets_config.set("planets.gallifrey.villager_blueprints.enabled", (Object)true);
            this.planets_config.set("planets.gallifrey.villager_blueprints.uses", (Object)1);
            this.planets_config.set("planets.gallifrey.villager_blueprints.chance", (Object)20);
            ++save;
        }
        if (!this.planets_config.contains("planets.gallifrey.villager_blueprints")) {
            this.planets_config.set("planets.gallifrey.villager_blueprints.enabled", (Object)true);
            this.planets_config.set("planets.gallifrey.villager_blueprints.uses", (Object)1);
            this.planets_config.set("planets.gallifrey.villager_blueprints.chance", (Object)20);
            ++save;
        }
        if (this.planets_config.getString("planets.skaro.generator").equalsIgnoreCase("DEFAULT")) {
            this.planets_config.set("planets.gallifrey.generator", (Object)"TARDIS:gallifrey");
            this.planets_config.set("planets.siluria.generator", (Object)"TARDIS:siluria");
            this.planets_config.set("planets.skaro.generator", (Object)"TARDIS:skaro");
            ++save;
        }
        if (!this.planets_config.contains("planets.telos")) {
            this.planets_config.set("planets.telos.enabled", (Object)false);
            this.planets_config.set("planets.telos.resource_pack", (Object)"default");
            this.planets_config.set("planets.telos.vastial.enabled", (Object)true);
            this.planets_config.set("planets.telos.vastial.gunpowder_chance", (Object)30);
            this.planets_config.set("planets.telos.twilight", (Object)true);
            this.planets_config.set("planets.telos.gamemode", (Object)"SURVIVAL");
            this.planets_config.set("planets.telos.time_travel", (Object)true);
            this.planets_config.set("planets.telos.world_type", (Object)"NORMAL");
            this.planets_config.set("planets.telos.environment", (Object)"NORMAL");
            this.planets_config.set("planets.telos.generator", (Object)"TARDIS:telos");
            this.planets_config.set("planets.telos.spawn_other_mobs", (Object)true);
            this.planets_config.set("planets.telos.gamerules.spawn_wandering_traders", (Object)false);
            this.planets_config.set("planets.telos.gamerules.spawn_patrols", (Object)false);
            this.planets_config.set("planets.telos.allow_portals", (Object)false);
            this.planets_config.set("planets.telos.alias", (Object)"Telos");
            this.planets_config.set("planets.telos.icon", (Object)"PACKED_ICE");
            this.planets_config.set("planets.telos.helmic_regulator_order", (Object)-1);
        }
        if (!this.planets_config.contains("planets.rooms")) {
            this.planets_config.set("planets.rooms.enabled", (Object)false);
            this.planets_config.set("planets.rooms.resource_pack", (Object)"default");
            this.planets_config.set("planets.rooms.gamemode", (Object)"SURVIVAL");
            this.planets_config.set("planets.rooms.time_travel", (Object)false);
            this.planets_config.set("planets.rooms.world_type", (Object)"FLAT");
            this.planets_config.set("planets.rooms.environment", (Object)"NORMAL");
            this.planets_config.set("planets.rooms.generator", (Object)"TARDIS:rooms");
            this.planets_config.set("planets.rooms.spawn_other_mobs", (Object)false);
            this.planets_config.set("planets.rooms.gamerules.advance_weather", (Object)false);
            this.planets_config.set("planets.rooms.gamerules.advance_time", (Object)false);
            this.planets_config.set("planets.rooms.gamerules.spawn_mobs", (Object)false);
            this.planets_config.set("planets.rooms.gamerules.spawn_wandering_traders", (Object)false);
            this.planets_config.set("planets.rooms.gamerules.spawn_patrols", (Object)false);
            this.planets_config.set("planets.rooms.gamerules.spawn_wardens", (Object)false);
            this.planets_config.set("planets.rooms.allow_portals", (Object)false);
            this.planets_config.set("planets.rooms.alias", (Object)"TARDISRooms");
            this.planets_config.set("planets.rooms.icon", (Object)"BOOKSHELF");
            this.planets_config.set("planets.rooms.transmat_location.x", (Object)8.5);
            this.planets_config.set("planets.rooms.transmat_location.y", (Object)68.0);
            this.planets_config.set("planets.rooms.transmat_location.z", (Object)2.5);
            ++save;
        }
        if (this.planets_config.getString("planets.TARDIS_TimeVortex.generator").equals("TARDISChunkGenerator")) {
            this.planets_config.set("planets.TARDIS_TimeVortex.generator", (Object)"TARDIS:void");
            this.planets_config.set("planets.TARDIS_Zero_Room.generator", (Object)"TARDIS:void");
            ++save;
        }
        if (this.planets_config.getString("planets.TARDIS_TimeVortex.generator").equals("TARDISChunkGenerator:void")) {
            for (Object w : worlds) {
                String[] split;
                String gen = this.planets_config.getString("planets." + (String)w + ".generator");
                if (gen == null || !gen.contains("TARDISChunkGenerator") || (split = gen.split(":")).length <= 1) continue;
                this.planets_config.set("planets." + (String)w + ".generator", (Object)("TARDIS:" + split[1]));
            }
            ++save;
        }
        for (Object w : worlds) {
            if (!this.planets_config.contains("planets." + (String)w + ".helmic_regultor_order")) continue;
            this.planets_config.set("planets." + (String)w + ".helmic_regultor_order", null);
            ++save;
        }
        String levelName = this.getLevelName();
        if (this.planets_config.contains("planets." + levelName + "_tardis_gallifrey")) {
            this.planets_config.set("planets." + levelName + "_tardis_gallifrey", null);
            ++save;
        }
        if (this.planets_config.contains("planets." + levelName + "_tardis_siluria")) {
            this.planets_config.set("planets." + levelName + "_tardis_siluria", null);
            ++save;
        }
        if (this.planets_config.contains("planets." + levelName + "_tardis_skaro")) {
            this.planets_config.set("planets." + levelName + "_tardis_skaro", null);
            ++save;
        }
        if (this.planets_config.contains("planets.TARDIS_TimeVortex.gamerules.doWardenSpawning")) {
            for (String w : worlds) {
                if (!this.planets_config.contains("planets." + w + ".gamerules") || this.planets_config.getConfigurationSection("planets." + w + ".gamerules") == null) continue;
                for (String rule : this.planets_config.getConfigurationSection("planets." + w + ".gamerules").getKeys(false)) {
                    String r = GameRuleConverter.OLD_TO_NEW.get(rule);
                    this.plugin.debug(r);
                    this.planets_config.set("planets." + w + ".gamerules." + r, (Object)this.planets_config.getBoolean("planets." + w + ".gamerules." + rule));
                    this.planets_config.set("planets." + w + ".gamerules." + rule, null);
                }
            }
            ++save;
        }
        if (save > 0) {
            try {
                String planetsPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "planets.yml";
                this.planets_config.save(new File(planetsPath));
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Added " + save + " new items to planets.yml");
            }
            catch (IOException io) {
                this.plugin.debug("Could not save planets.yml, " + io.getMessage());
            }
        }
    }

    private String getLevelName() {
        try {
            BufferedReader is = new BufferedReader(new FileReader("server.properties"));
            Properties props = new Properties();
            props.load(is);
            is.close();
            return props.getProperty("level-name");
        }
        catch (IOException e) {
            return "world";
        }
    }

    private String getDifficulty() {
        try {
            BufferedReader is = new BufferedReader(new FileReader("server.properties"));
            Properties props = new Properties();
            props.load(is);
            is.close();
            return props.getProperty("difficulty").toUpperCase(Locale.ROOT);
        }
        catch (IOException e) {
            return "EASY";
        }
    }

    private String getIcon(String world, String env) {
        return switch (world) {
            case "TARDIS_TimeVortex" -> "CRYING_OBSIDIAN";
            case "TARDIS_Zero_Room" -> "PINK_WOOL";
            case "skaro" -> "FIRE_CORAL_BLOCK";
            case "siluria" -> "BAMBOO_MOSAIC";
            case "gallifrey" -> "RED_SAND";
            default -> {
                if (env != null) {
                    switch (env) {
                        case "NETHER": {
                            yield "NETHERRACK";
                        }
                        case "THE_END": {
                            yield "END_STONE";
                        }
                    }
                    yield "STONE";
                }
                yield "DIRT";
            }
        };
    }
}

