/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors.inner;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.keys.BoneDoorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ClassicDoorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SidratDoorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.TardisDoorVariant;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.doors.Door;
import me.eccentric_nz.TARDIS.doors.DoorAnimator;
import me.eccentric_nz.TARDIS.doors.DoorUtility;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InnerDisplayDoorCloser {
    private final TARDIS plugin;

    public InnerDisplayDoorCloser(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void close(Block block, int id, UUID uuid, boolean outside) {
        TARDISDisplayItem tdi;
        ItemDisplay display = TARDISDisplayItemUtils.getFromBoundingBox(block);
        if (display != null && (tdi = TARDISDisplayItemUtils.get(display)) != null) {
            if (outside) {
                ItemStack itemStack = display.getItemStack();
                ItemMeta im = itemStack.getItemMeta();
                if (tdi.toString().endsWith("OPEN") || tdi == TARDISBlockDisplayItem.CUSTOM_DOOR) {
                    switch (tdi.getMaterial()) {
                        case IRON_DOOR: {
                            im.setItemModel(TardisDoorVariant.TARDIS_DOOR_CLOSED.getKey());
                            break;
                        }
                        case BIRCH_DOOR: {
                            im.setItemModel(BoneDoorVariant.BONE_DOOR_CLOSED.getKey());
                            break;
                        }
                        case CHERRY_DOOR: {
                            im.setItemModel(ClassicDoorVariant.CLASSIC_DOOR_CLOSED.getKey());
                            break;
                        }
                        case PALE_OAK_DOOR: {
                            im.setItemModel(SidratDoorVariant.SIDRAT_DOOR_CLOSED.getKey());
                            break;
                        }
                        default: {
                            im.setItemModel(Door.getClosedModel(tdi.getMaterial()));
                        }
                    }
                }
                itemStack.setItemMeta(im);
                display.setItemStack(itemStack);
            } else {
                new DoorAnimator(this.plugin, display).animate(true);
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                TARDISTeleportLocation removed = this.plugin.getTrackerKeeper().getPortals().remove(block.getLocation());
                if (removed == null) {
                    DoorUtility.debugPortal(block.getLocation().toString());
                }
                if (!this.plugin.getConfig().getBoolean("preferences.open_door_policy")) {
                    if (tardis.getCompanions().equalsIgnoreCase("everyone")) {
                        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                            this.plugin.getTrackerKeeper().getMovers().remove(p.getUniqueId());
                        }
                    } else {
                        String[] companions;
                        for (String c : companions = tardis.getCompanions().split(":")) {
                            if (c.isEmpty()) continue;
                            this.plugin.getTrackerKeeper().getMovers().remove(UUID.fromString(c));
                        }
                        this.plugin.getTrackerKeeper().getMovers().remove(uuid);
                    }
                }
            }
        }
    }
}

