/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.console.CustomiseConsoleInventory;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonPresets;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCount;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTransmat;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.desktop.PreviewData;
import me.eccentric_nz.TARDIS.desktop.TARDISArchiveInventory;
import me.eccentric_nz.TARDIS.desktop.TARDISCustomThemeInventory;
import me.eccentric_nz.TARDIS.desktop.TARDISPluginThemeInventory;
import me.eccentric_nz.TARDIS.desktop.TARDISRepair;
import me.eccentric_nz.TARDIS.desktop.TARDISThemeInventory;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.desktop.TARDISWallsInventory;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.schematic.archive.ArchiveUpdate;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TARDISThemeMenuListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISThemeMenuListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onThemeMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISPluginThemeInventory) && !(event.getInventory().getHolder(false) instanceof TARDISCustomThemeInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        ClickType click = event.getClick();
        if (slot < 0 || slot > 53) {
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                event.setCancelled(true);
            }
            return;
        }
        ItemStack choice = event.getView().getItem(slot);
        event.setCancelled(true);
        switch (slot) {
            case 45: {
                break;
            }
            case 46: {
                if (choice == null) break;
                this.archive(player);
                break;
            }
            case 47: {
                if (choice == null || !this.plugin.getConfig().getBoolean("allow.repair")) break;
                this.repair(player);
                break;
            }
            case 48: {
                if (choice == null || !this.plugin.getConfig().getBoolean("allow.repair")) break;
                this.clean(player);
                break;
            }
            case 49: {
                CustomiseConsoleInventory customise = new CustomiseConsoleInventory(this.plugin);
                player.openInventory(customise.getInventory());
                break;
            }
            case 51: {
                TARDISUpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(player.getUniqueId());
                TARDISThemeInventory consoles = GUIChameleonPresets.GO_TO_PAGE_2.name().equals(choice.getItemMeta().displayName()) ? new TARDISCustomThemeInventory(this.plugin, player, tud.getPrevious().getPermission(), tud.getLevel()) : new TARDISPluginThemeInventory(this.plugin, player, tud.getPrevious().getPermission(), tud.getLevel());
                player.openInventory(consoles.getInventory());
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
            default: {
                int needed;
                if (choice == null) {
                    return;
                }
                String perm = Desktops.schematicFor(choice.getType()).getPermission();
                Schematic schematic = Desktops.schematicFor(perm);
                UUID uuid = player.getUniqueId();
                if (click.equals((Object)ClickType.SHIFT_LEFT) && this.plugin.getConfig().getBoolean("desktop.previews")) {
                    ResultSetTransmat rst = new ResultSetTransmat(this.plugin, schematic.getPreview(), schematic.getPermission());
                    if (!rst.resultSet()) break;
                    Location transmat = rst.getLocation();
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_PREVIEW", schematic.getPermission().toUpperCase(Locale.ROOT));
                    transmat.setYaw(rst.getYaw());
                    transmat.setPitch(player.getLocation().getPitch());
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("uuid", uuid.toString());
                    ResultSetTravellers rs = new ResultSetTravellers(this.plugin, where, false);
                    rs.resultSet();
                    this.plugin.getTrackerKeeper().getPreviewers().put(uuid, new PreviewData(player.getLocation().clone(), player.getGameMode(), rs.getTardis_id()));
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        player.setGameMode(GameMode.ADVENTURE);
                        player.playSound(transmat, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                        player.teleport(transmat);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREVIEW_DONE");
                    }, 10L);
                    this.close(player);
                    break;
                }
                if (!TARDISPermission.hasPermission(player, "tardis." + perm)) {
                    return;
                }
                TARDISUpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(uuid);
                int upgrade = this.plugin.getArtronConfig().getInt("upgrades." + perm);
                int n = needed = tud.getPrevious().getPermission().equals(schematic.getPermission()) ? upgrade / 2 : upgrade;
                if (tud.getLevel() < needed) break;
                tud.setSchematic(schematic);
                this.plugin.getTrackerKeeper().getUpgrades().put(uuid, tud);
                this.wall(player);
                if (!tud.getPrevious().getPermission().equals("archive")) break;
                new ArchiveUpdate(this.plugin, uuid.toString(), "\u00aa\u00b0\u00ba").setInUse();
            }
        }
    }

    @Override
    public void close(Player player) {
        this.plugin.getTrackerKeeper().getUpgrades().remove(player.getUniqueId());
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Player)player).closeInventory(), 1L);
    }

    private void wall(Player p) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            p.closeInventory();
            p.openInventory(new TARDISWallsInventory(this.plugin, "TARDIS Wall Menu").getInventory());
        }, 1L);
    }

    private void archive(Player p) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            p.closeInventory();
            p.openInventory(new TARDISArchiveInventory(this.plugin, p).getInventory());
        }, 1L);
    }

    private void repair(Player p) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            boolean repair;
            p.closeInventory();
            String uuid = p.getUniqueId().toString();
            TARDISRepair tr = new TARDISRepair(this.plugin, p);
            ResultSetCount rsc = new ResultSetCount(this.plugin, uuid);
            if (rsc.resultSet() && rsc.getRepair() > 0) {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", uuid);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("repair", rsc.getRepair() - 1);
                this.plugin.getQueryFactory().doUpdate("t_count", set, where);
                repair = true;
            } else {
                repair = tr.hasCondensedMissingBlocks();
            }
            if (repair) {
                tr.restore(false);
            }
        }, 1L);
    }

    private void clean(Player p) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            p.closeInventory();
            new TARDISRepair(this.plugin, p).restore(true);
        }, 1L);
    }
}

