/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.control.TARDISThemeButton;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.TARDISArchiveInventory;
import me.eccentric_nz.TARDIS.desktop.TARDISRandomArchiveName;
import me.eccentric_nz.TARDIS.desktop.TARDISThemeProcessor;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.enumeration.ConsoleSize;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.schematic.archive.ArchiveUpdate;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISArchiveMenuListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISArchiveMenuListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onThemeMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISArchiveInventory)) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 26) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        InventoryView view = event.getView();
        switch (slot) {
            case 17: {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", p.getUniqueId().toString());
                ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                rs.resultSet();
                Tardis tardis = rs.getTardis();
                this.close(p);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new TARDISThemeButton(this.plugin, p, tardis.getSchematic(), tardis.getArtronLevel(), tardis.getTardisId()).clickButton(), 2L);
                break;
            }
            case 18: {
                ItemStack iss = view.getItem(18);
                ItemMeta ims = iss.getItemMeta();
                List lores = ims.lore();
                int o = ConsoleSize.valueOf(ComponentUtils.stripColour((Component)lores.getFirst())).ordinal();
                int s = o < 3 ? o + 1 : 0;
                String t = ConsoleSize.values()[s].toString();
                String b = ConsoleSize.values()[s].getBlocks();
                if (t == null) break;
                ims.lore(List.of(Component.text((String)t), Component.text((String)b), Component.text((String)"Click to change", (TextColor)NamedTextColor.AQUA)));
                iss.setItemMeta(ims);
                break;
            }
            case 19: {
                this.scan(p, view);
                break;
            }
            case 20: {
                this.archive(p, view);
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                ItemStack template = view.getItem(slot);
                if (template == null) break;
                UUID uuid = p.getUniqueId();
                TARDISUpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(uuid);
                ItemMeta im = template.getItemMeta();
                String dn = ComponentUtils.stripColour(im.displayName());
                String size = dn.toLowerCase(Locale.ROOT);
                int upgrade = this.plugin.getArtronConfig().getInt("upgrades.template." + size);
                if (tud.getLevel() < upgrade) break;
                new ArchiveUpdate(this.plugin, uuid.toString(), dn).setInUse();
                tud.setSchematic(Desktops.schematicFor(size));
                tud.setWall("ORANGE_WOOL");
                tud.setFloor("LIGHT_GRAY_WOOL");
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    this.plugin.getTrackerKeeper().getUpgrades().put(uuid, tud);
                    new TARDISThemeProcessor(this.plugin, uuid).changeDesktop();
                }, 10L);
                this.close(p);
                break;
            }
            case 26: {
                this.close(p);
                break;
            }
            default: {
                ItemStack choice = view.getItem(slot);
                if (choice == null) break;
                Schematic schm = Desktops.schematicFor("archive");
                UUID uuid = p.getUniqueId();
                TARDISUpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(uuid);
                ItemMeta im = choice.getItemMeta();
                List lore = im.lore();
                if (lore == null || lore.contains(Component.text((String)this.plugin.getLanguage().getString("CURRENT_CONSOLE", ""), (TextColor)NamedTextColor.GREEN))) {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ARCHIVE_NOT_CURRENT");
                    return;
                }
                int upgrade = this.plugin.getArtronConfig().getInt("upgrades.archive.tall");
                for (Component l : lore) {
                    String c = ComponentUtils.stripColour(l);
                    if (!c.startsWith("Cost")) continue;
                    upgrade = TARDISNumberParsers.parseInt(c.replace("Cost: ", ""));
                }
                if (tud.getLevel() < upgrade) break;
                new ArchiveUpdate(this.plugin, uuid.toString(), ComponentUtils.stripColour(im.displayName())).setInUse();
                tud.setSchematic(schm);
                tud.setWall("ORANGE_WOOL");
                tud.setFloor("LIGHT_GRAY_WOOL");
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    this.plugin.getTrackerKeeper().getUpgrades().put(uuid, tud);
                    new TARDISThemeProcessor(this.plugin, uuid).changeDesktop();
                }, 10L);
                this.close(p);
            }
        }
    }

    @Override
    public void close(Player player) {
        this.plugin.getTrackerKeeper().getUpgrades().remove(player.getUniqueId());
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Player)player).closeInventory(), 1L);
    }

    private void scan(Player p, InventoryView view) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            List<Component> lore = this.getSizeLore(view);
            String size = ComponentUtils.stripColour(lore.getFirst());
            p.closeInventory();
            p.performCommand("tardis archive scan " + size);
        }, 1L);
    }

    private void archive(Player p, InventoryView view) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            List<Component> lore = this.getSizeLore(view);
            String size = ComponentUtils.stripColour(lore.getFirst());
            p.closeInventory();
            String name = TARDISRandomArchiveName.getRandomName();
            p.performCommand("tardis archive add " + name + " " + size);
        }, 1L);
    }

    private List<Component> getSizeLore(InventoryView view) {
        ItemStack is = view.getItem(18);
        ItemMeta im = is.getItemMeta();
        return im.lore();
    }
}

