/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;

public class ResultSetTardisModel {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private String itemPreset = "";
    private String itemDemat = "";

    public ResultSetTardisModel(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromID(int id) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT uuid, chameleon_preset, chameleon_demat FROM " + this.prefix + "tardis WHERE tardis_id = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setInt(1, id);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                String[] split;
                rs.next();
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                if (rs.getString("chameleon_preset").startsWith("ITEM:")) {
                    split = rs.getString("chameleon_preset").split(":");
                    if (split.length > 1) {
                        this.itemPreset = split[1];
                    } else {
                        this.itemPreset = "Bad Wolf";
                        TARDISStaticUtils.warnPreset(uuid);
                    }
                }
                if (rs.getString("chameleon_demat").startsWith("ITEM:")) {
                    split = rs.getString("chameleon_demat").split(":");
                    if (split.length > 1) {
                        this.itemDemat = split[1];
                    } else {
                        this.itemDemat = "Bad Wolf";
                        TARDISStaticUtils.warnPreset(uuid);
                    }
                }
                boolean split2 = true;
                return split2;
            }
            boolean uuid = false;
            return uuid;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for tardis [custom model keys fromID] table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tardis [custom model keys fromID] table! " + e.getMessage());
            }
        }
    }

    public String getItemPreset() {
        return this.itemPreset;
    }

    public String getItemDemat() {
        return this.itemDemat;
    }
}

