/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.Schematic;

public class ResultSetTardisAbandoned {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private int tardis_id;
    private int artron_level;
    private Schematic schematic;
    private ChameleonPreset preset;
    private boolean handbrake_on;
    private boolean hidden;
    private boolean tardis_init;
    private boolean powered_on;
    private boolean lights_on;

    public ResultSetTardisAbandoned(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromUUID(String uuid) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT tardis_id, artron_level, size, chameleon_preset, handbrake_on, hidden, tardis_init, powered_on, lights_on FROM " + this.prefix + "tardis WHERE uuid = ? AND abandoned = 0";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, uuid);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                this.tardis_id = rs.getInt("tardis_id");
                this.artron_level = rs.getInt("artron_level");
                this.schematic = Desktops.schematicFor(rs.getString("size").toLowerCase(Locale.ROOT));
                String p = rs.getString("chameleon_preset");
                if (p.startsWith("ITEM:")) {
                    this.preset = ChameleonPreset.ITEM;
                } else {
                    try {
                        this.preset = ChameleonPreset.valueOf(p);
                    }
                    catch (IllegalArgumentException e) {
                        this.preset = ChameleonPreset.FACTORY;
                    }
                }
                this.handbrake_on = rs.getBoolean("handbrake_on");
                this.hidden = rs.getBoolean("hidden");
                this.tardis_init = rs.getBoolean("tardis_init");
                this.powered_on = rs.getBoolean("powered_on");
                this.lights_on = rs.getBoolean("lights_on");
                boolean e = true;
                return e;
            }
            boolean p = false;
            return p;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for tardis [not abandoned] table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tardis [not abandoned] table! " + e.getMessage());
            }
        }
    }

    public int getTardis_id() {
        return this.tardis_id;
    }

    public int getArtron_level() {
        return this.artron_level;
    }

    public Schematic getSchematic() {
        return this.schematic;
    }

    public ChameleonPreset getPreset() {
        return this.preset;
    }

    public boolean isHandbrake_on() {
        return this.handbrake_on;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isTardis_init() {
        return this.tardis_init;
    }

    public boolean isPowered_on() {
        return this.powered_on;
    }

    public boolean isLights_on() {
        return this.lights_on;
    }
}

