/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Program;

public class ResultSetPrograms {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String uuid;
    private final String prefix;
    private final List<Program> programs;

    public ResultSetPrograms(TARDIS plugin, String uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.prefix = this.plugin.getPrefix();
        this.programs = new ArrayList<Program>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT program_id, name, checked FROM " + this.prefix + "programs WHERE uuid = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.uuid);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        Program program = new Program(rs.getInt("program_id"), "", rs.getString("name"), "", "", rs.getBoolean("checked"));
                        this.programs.add(program);
                    }
                    break block17;
                }
                boolean program = false;
                return program;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for programs table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing programs table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public List<Program> getPrograms() {
        return this.programs;
    }
}

