/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetPlotCount {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public ResultSetPlotCount(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fromUUID(String uuid) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT COUNT(*) AS count FROM " + this.prefix + "plots WHERE uuid = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, uuid);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                int n = rs.getInt("count");
                return n;
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for plots table! " + e.getMessage());
            int n = 0;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing blueprint table! " + e.getMessage());
            }
        }
        return 0;
    }
}

