/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.Autonomous;
import me.eccentric_nz.TARDIS.enumeration.HADS;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;

public class ResultSetPlayerPrefs {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String where;
    private final String prefix;
    private int pp_id;
    private boolean announceRepeatersOn;
    private boolean autoOn;
    private Autonomous autoType;
    private Autonomous.Default autoDefault;
    private boolean autoPowerUp;
    private boolean autoRescueOn;
    private boolean autoSiegeOn;
    private boolean beaconOn;
    private boolean buildOn;
    private boolean closeGUIOn;
    private boolean DND;
    private boolean dynamicLightsOn;
    private boolean epsOn;
    private boolean farmOn;
    private boolean hadsOn;
    private TardisLight lights;
    private boolean minecartOn;
    private boolean quotesOn;
    private boolean rendererOn;
    private boolean sfxOn;
    private boolean signOn;
    private boolean submarineOn;
    private boolean telepathyOn;
    private boolean travelbarOn;
    private boolean infoOn;
    private boolean dialogsOn;
    private boolean openDisplayDoorOn;
    private HADS hadsType;
    private int artronLevel;
    private int flightMode;
    private int throttle;
    private String epsMessage;
    private String floor;
    private String hum;
    private String key;
    private String language;
    private String siegeFloor;
    private String siegeWall;
    private String wall;

    public ResultSetPlayerPrefs(TARDIS plugin, String uuid) {
        this.plugin = plugin;
        this.where = uuid;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resultSet() {
        String query = "SELECT * FROM " + this.prefix + "player_prefs WHERE uuid = ?";
        this.service.testConnection(this.connection);
        try (PreparedStatement statement = this.connection.prepareStatement(query);){
            statement.setString(1, this.where);
            try (ResultSet rs = statement.executeQuery();){
                if (rs.next()) {
                    this.pp_id = rs.getInt("pp_id");
                    this.key = this.plugin.getConfig().getString("storage.database", "sqlite").equals("sqlite") ? rs.getString("key") : rs.getString("key_item");
                    this.sfxOn = rs.getBoolean("sfx_on");
                    this.quotesOn = rs.getBoolean("quotes_on");
                    this.announceRepeatersOn = rs.getBoolean("announce_repeaters_on");
                    this.autoOn = rs.getBoolean("auto_on");
                    try {
                        this.autoType = Autonomous.valueOf(rs.getString("auto_type"));
                    }
                    catch (IllegalArgumentException e) {
                        this.autoType = Autonomous.CLOSEST;
                    }
                    try {
                        this.autoDefault = Autonomous.Default.valueOf(rs.getString("auto_default"));
                    }
                    catch (IllegalArgumentException e) {
                        this.autoDefault = Autonomous.Default.HOME;
                    }
                    this.autoRescueOn = rs.getBoolean("auto_rescue_on");
                    this.autoSiegeOn = rs.getBoolean("auto_siege_on");
                    this.beaconOn = rs.getBoolean("beacon_on");
                    this.hadsOn = rs.getBoolean("hads_on");
                    String ht = rs.getString("hads_type");
                    this.hadsType = rs.wasNull() ? HADS.DISPLACEMENT : HADS.valueOf(ht);
                    this.submarineOn = rs.getBoolean("submarine_on");
                    this.artronLevel = rs.getInt("artron_level");
                    this.language = rs.getString("language");
                    this.wall = rs.getString("wall");
                    this.floor = rs.getString("floor");
                    this.siegeWall = rs.getString("siege_wall");
                    this.siegeFloor = rs.getString("siege_floor");
                    this.buildOn = rs.getBoolean("build_on");
                    this.closeGUIOn = rs.getBoolean("close_gui_on");
                    this.dynamicLightsOn = rs.getBoolean("dynamic_lamps_on");
                    this.epsOn = rs.getBoolean("eps_on");
                    String message = rs.getString("eps_message");
                    this.epsMessage = rs.wasNull() || message.isEmpty() ? "This is Emergency Programme One. I have died. I'm sure I will regenerate soon, but just in case. I have engaged the TARDIS autonomous circuit, and we are returning to my Home location or a recharge point - which ever is closest!" : rs.getString("eps_message");
                    this.DND = rs.getBoolean("dnd_on");
                    this.minecartOn = rs.getBoolean("minecart_on");
                    this.rendererOn = rs.getBoolean("renderer_on");
                    this.signOn = rs.getBoolean("sign_on");
                    this.telepathyOn = rs.getBoolean("telepathy_on");
                    this.travelbarOn = rs.getBoolean("travelbar_on");
                    this.infoOn = rs.getBoolean("info_on");
                    this.farmOn = rs.getBoolean("farm_on");
                    try {
                        this.lights = TardisLight.valueOf(rs.getString("lights"));
                    }
                    catch (IllegalArgumentException e) {
                        this.lights = TardisLight.TENTH;
                    }
                    this.flightMode = rs.getInt("flying_mode");
                    this.throttle = rs.getInt("throttle");
                    this.autoPowerUp = rs.getBoolean("auto_powerup_on");
                    this.hum = rs.getString("hum");
                    this.dialogsOn = rs.getBoolean("dialogs_on");
                    this.openDisplayDoorOn = rs.getBoolean("open_display_door_on");
                    return true;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for player_prefs table! " + e.getMessage());
            return false;
        }
    }

    public int getPp_id() {
        return this.pp_id;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isSfxOn() {
        return this.sfxOn;
    }

    public boolean isQuotesOn() {
        return this.quotesOn;
    }

    public boolean isAnnounceRepeatersOn() {
        return this.announceRepeatersOn;
    }

    public boolean isAutoOn() {
        return this.autoOn;
    }

    public Autonomous getAutoType() {
        return this.autoType;
    }

    public Autonomous.Default getAutoDefault() {
        return this.autoDefault;
    }

    public boolean isAutoSiegeOn() {
        return this.autoSiegeOn;
    }

    public boolean isBeaconOn() {
        return this.beaconOn;
    }

    public boolean isHadsOn() {
        return this.hadsOn;
    }

    public HADS getHadsType() {
        return this.hadsType;
    }

    public int getArtronLevel() {
        return this.artronLevel;
    }

    public String getWall() {
        return this.wall;
    }

    public String getFloor() {
        return this.floor;
    }

    public String getSiegeWall() {
        return this.siegeWall;
    }

    public String getSiegeFloor() {
        return this.siegeFloor;
    }

    public boolean isBuildOn() {
        return this.buildOn;
    }

    public boolean isCloseGUIOn() {
        return this.closeGUIOn;
    }

    public boolean isDynamicLightsOn() {
        return this.dynamicLightsOn;
    }

    public boolean isEpsOn() {
        return this.epsOn;
    }

    public String getEpsMessage() {
        return this.epsMessage;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isSubmarineOn() {
        return this.submarineOn;
    }

    public boolean isDND() {
        return this.DND;
    }

    public boolean isMinecartOn() {
        return this.minecartOn;
    }

    public boolean isRendererOn() {
        return this.rendererOn;
    }

    public boolean isSignOn() {
        return this.signOn;
    }

    public boolean isTelepathyOn() {
        return this.telepathyOn;
    }

    public boolean isTravelbarOn() {
        return this.travelbarOn;
    }

    public boolean isInfoOn() {
        return this.infoOn;
    }

    public boolean isFarmOn() {
        return this.farmOn;
    }

    public TardisLight getLights() {
        return this.lights;
    }

    public int getFlightMode() {
        return this.flightMode;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public boolean isAutoPowerUp() {
        return this.autoPowerUp;
    }

    public boolean isAutoRescueOn() {
        return this.autoRescueOn;
    }

    public String getHum() {
        return this.hum;
    }

    public boolean isDialogsOn() {
        return this.dialogsOn;
    }

    public boolean isOpenDisplayDoorOn() {
        return this.openDisplayDoorOn;
    }
}

