/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Lamp;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;

public class ResultSetLamps {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final boolean multiple;
    private final List<Lamp> data = new ArrayList<Lamp>();
    private final String prefix;
    private Lamp lamp = null;

    public ResultSetLamps(TARDIS plugin, HashMap<String, Object> where, boolean multiple) {
        this.plugin = plugin;
        this.where = where;
        this.multiple = multiple;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block29: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "lamps" + (String)wheres;
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    int s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        Location loc = TARDISStaticLocationGetters.getLocationFromDB(rs.getString("location"));
                        if (loc == null) continue;
                        String materialOnStr = rs.getString("material_on");
                        Material materialOn = null;
                        if (!materialOnStr.isEmpty()) {
                            try {
                                materialOn = Material.valueOf((String)materialOnStr);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        String materialOffStr = rs.getString("material_off");
                        Material materialOff = null;
                        if (!materialOffStr.isEmpty()) {
                            try {
                                materialOff = Material.valueOf((String)materialOffStr);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        float percentage = Math.clamp(rs.getFloat("percentage"), 0.0f, 1.0f);
                        if (this.multiple) {
                            this.data.add(new Lamp(loc.getBlock(), materialOn, materialOff, percentage));
                        }
                        this.lamp = new Lamp(loc.getBlock(), materialOn, materialOff, percentage);
                    }
                    break block29;
                }
                boolean loc = false;
                return loc;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for lamps table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing lamps table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public List<Lamp> getData() {
        return this.data;
    }

    public Lamp getLamp() {
        return this.lamp;
    }
}

