/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetInteractionCheck {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public ResultSetInteractionCheck(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSetFromUUID(UUID uuid) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT " + this.prefix + "interactions.i_id FROM " + this.prefix + "interactions, " + this.prefix + "tardis WHERE " + this.prefix + "tardis.uuid = ? AND " + this.prefix + "interactions.tardis_id = " + this.prefix + "tardis.tardis_id";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, uuid.toString());
            rs = statement.executeQuery();
            boolean bl = rs.isBeforeFirst();
            return bl;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for interactions UUID check! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing interactions UUID check! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSetFromId(int id) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT " + this.prefix + "interactions.i_id FROM " + this.prefix + "interactions, " + this.prefix + "tardis WHERE " + this.prefix + "tardis.tardis_id = ? AND " + this.prefix + "interactions.tardis_id = " + this.prefix + "tardis.tardis_id";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setInt(1, id);
            rs = statement.executeQuery();
            boolean bl = rs.isBeforeFirst();
            return bl;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for interactions id check! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing interactions id check! " + e.getMessage());
            }
        }
    }
}

