/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.FarmPrefs;

public class ResultSetFarmingPrefs {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String uuid;
    private final String prefix;
    private FarmPrefs data;

    public ResultSetFarmingPrefs(TARDIS plugin, String uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block16: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "farming_prefs WHERE uuid = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.uuid);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.data = new FarmPrefs(UUID.fromString(rs.getString("uuid")), rs.getBoolean("allay"), rs.getBoolean("apiary"), rs.getBoolean("aquarium"), rs.getBoolean("bamboo"), rs.getBoolean("birdcage"), rs.getBoolean("farm"), rs.getBoolean("geode"), rs.getBoolean("happy"), rs.getBoolean("hutch"), rs.getBoolean("igloo"), rs.getBoolean("iistubil"), rs.getBoolean("lava"), rs.getBoolean("mangrove"), rs.getBoolean("nautilus"), rs.getBoolean("pen"), rs.getBoolean("stable"), rs.getBoolean("stall"), rs.getBoolean("village"));
                    break block16;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for farming_prefs table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing farming_prefs table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public FarmPrefs getData() {
        return this.data;
    }
}

