/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class ResultSetDoorBlocks {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int id;
    private final String prefix;
    private Block innerBlock;
    private Block outerBlock;

    public ResultSetDoorBlocks(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block18: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "doors WHERE door_type IN (0,1) AND tardis_id = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, this.id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        String door = rs.getString("door_location");
                        Location doorLocation = TARDISStaticLocationGetters.getLocationFromDB(door);
                        if (rs.getInt("door_type") == 0) {
                            this.outerBlock = doorLocation == null ? null : doorLocation.getBlock();
                            continue;
                        }
                        this.innerBlock = doorLocation == null ? null : doorLocation.getBlock();
                    }
                    break block18;
                }
                boolean door = false;
                return door;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for door! " + e.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing door! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public Block getInnerBlock() {
        return this.innerBlock;
    }
}

