/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class TARDISWallSignConverter {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public TARDISWallSignConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertSignBlocks() {
        Statement statement = null;
        Statement ps = null;
        ResultSet rs = null;
        String query = "SELECT b_id, data FROM " + this.prefix + "blocks WHERE data LIKE 'minecraft:wall_sign%'";
        String update = "UPDATE " + this.prefix + "blocks SET data = 'minecraft:oak_wall_sign[facing=north,waterlogged=false]' WHERE b_id = ?";
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            statement = this.connection.prepareStatement(query);
            ps = this.connection.prepareStatement(update);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    ps.setInt(1, rs.getInt("b_id"));
                    ps.addBatch();
                    if (++i <= 0) continue;
                    ps.executeBatch();
                    this.connection.commit();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " legacy wall signs to oak wall signs");
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Conversion error for wall sign blocks! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing blocks table (wall signs)! " + e.getMessage());
            }
        }
    }
}

