/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

class TARDISSQLUpdateLocations
implements Runnable {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final HashMap<String, Object> data;
    private final int id;
    private final String prefix;

    TARDISSQLUpdateLocations(TARDIS plugin, HashMap<String, Object> data, int id) {
        this.plugin = plugin;
        this.data = data;
        this.id = id;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String[] tables = new String[]{"current", "next", "back"};
        Statement ps = null;
        StringBuilder sbu = new StringBuilder();
        this.data.forEach((key, value) -> sbu.append((String)key).append(" = ?,"));
        String updates = sbu.substring(0, sbu.length() - 1);
        try {
            this.service.testConnection(this.connection);
            for (String s : tables) {
                ps = this.connection.prepareStatement("UPDATE " + this.prefix + s + " SET " + updates + " WHERE tardis_id = ?");
                int i = 1;
                for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                    if (entry.getValue() instanceof String) {
                        ps.setString(i, entry.getValue().toString());
                    } else {
                        ps.setInt(i, (Integer)entry.getValue());
                    }
                    ++i;
                }
                ps.setInt(7, this.id);
                ps.executeUpdate();
            }
            this.data.clear();
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for travel stop locations! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing travel stop location tables! " + e.getMessage());
            }
        }
    }
}

