/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

class TARDISDispersalUpdater {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;

    TARDISDispersalUpdater(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTardis_ids() {
        int i = 0;
        Statement statement = null;
        ResultSet rs = null;
        ResultSet rst = null;
        Statement ps_select = null;
        Statement ps_update = null;
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery("SELECT d_id, uuid FROM " + this.prefix + "dispersed");
            if (rs.isBeforeFirst()) {
                ps_select = this.connection.prepareStatement("SELECT tardis_id FROM " + this.prefix + "tardis WHERE uuid = ?");
                ps_update = this.connection.prepareStatement("UPDATE " + this.prefix + "dispersed SET tardis_id = ? WHERE d_id = ?");
                while (rs.next()) {
                    ps_select.setString(1, rs.getString("uuid"));
                    rst = ps_select.executeQuery();
                    if (!rst.next()) continue;
                    ps_update.setInt(1, rst.getInt("tardis_id"));
                    ps_update.setInt(2, rs.getInt("d_id"));
                    ps_update.executeUpdate();
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Dispersal update error: " + e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.plugin.debug("Dispersal statement close error: " + e.getMessage());
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.plugin.debug("Dispersal statement close error: " + e.getMessage());
                }
            }
            if (rst != null) {
                try {
                    rst.close();
                }
                catch (SQLException e) {
                    this.plugin.debug("Dispersal statement close error: " + e.getMessage());
                }
            }
            if (ps_select != null) {
                try {
                    ps_select.close();
                }
                catch (SQLException e) {
                    this.plugin.debug("Dispersal select prepared statement close error: " + e.getMessage());
                }
            }
            if (ps_update != null) {
                try {
                    ps_update.close();
                }
                catch (SQLException e) {
                    this.plugin.debug("Dispersal update prepared statement close error: " + e.getMessage());
                }
            }
        }
        if (i > 0) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Updated " + i + " dispersed records");
        }
    }
}

