/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.customblocks;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.keys.LightVariant;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;

public class VariableLight {
    private final Material material;
    private final Location location;
    private final Transformation transformation = new Transformation(TARDISConstants.VECTOR_ZERO, TARDISConstants.AXIS_ANGLE_ZERO, new Vector3f(0.99f, 0.99f, 0.99f), TARDISConstants.AXIS_ANGLE_ZERO);

    public VariableLight(Material material, Location location) {
        this.material = material;
        this.location = location;
    }

    public VariableLight(Location location) {
        this.material = null;
        this.location = location;
    }

    public void set() {
        this.set(LightVariant.OFF.getKey(), 15);
    }

    public void set(NamespacedKey model, int level) {
        World world = this.location.getWorld();
        ItemDisplay roundel = (ItemDisplay)world.spawnEntity(this.location, EntityType.ITEM_DISPLAY);
        roundel.getPersistentDataContainer().set(TARDIS.plugin.getTardisIdKey(), PersistentDataType.BOOLEAN, (Object)true);
        ItemStack r = ItemStack.of((Material)Material.GLASS);
        ItemMeta rim = r.getItemMeta();
        rim.setItemModel(model);
        r.setItemMeta(rim);
        roundel.setItemStack(r);
        ItemDisplay inner = (ItemDisplay)world.spawnEntity(this.location, EntityType.ITEM_DISPLAY);
        ItemStack b = ItemStack.of((Material)this.material);
        inner.setItemStack(b);
        inner.setTransformation(this.transformation);
        Levelled light = TARDISConstants.LIGHT;
        light.setLevel(level);
        this.location.getBlock().setBlockData((BlockData)light);
        Interaction interaction = (Interaction)world.spawnEntity(this.location.clone().subtract(0.0, 0.5, 0.0), EntityType.INTERACTION);
        interaction.setResponsive(true);
        interaction.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.INTEGER, (Object)1001);
        interaction.setPersistent(true);
    }

    public void change(NamespacedKey model, int level) {
        Block block = this.location.getBlock();
        for (ItemDisplay display : TARDISDisplayItemUtils.getAll(block)) {
            if (!display.getPersistentDataContainer().has(TARDIS.plugin.getTardisIdKey(), PersistentDataType.BOOLEAN)) continue;
            ItemStack roundel = display.getItemStack();
            ItemMeta rim = roundel.getItemMeta();
            rim.setItemModel(model);
            roundel.setItemMeta(rim);
            display.setItemStack(roundel);
        }
        Levelled light = TARDISConstants.LIGHT;
        light.setLevel(level);
        block.setBlockData((BlockData)light);
    }
}

