/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.telepathic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.telepathic.EnvironmentBiomes;
import me.eccentric_nz.TARDIS.console.telepathic.TARDISTelepathicBiome;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TelepathicBiomeListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, Integer> scroll = new HashMap();
    private final List<UUID> scrolling = new ArrayList<UUID>();
    private final ItemStack[][] biomes;
    private final int rows;

    public TelepathicBiomeListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.rows = EnvironmentBiomes.OVERWORLD.size() / 8 + 1;
        this.biomes = this.getBiomes();
    }

    @EventHandler
    public void onWallMenuOpen(InventoryOpenEvent event) {
        if (event.getInventory().getHolder(false) instanceof TARDISTelepathicBiome) {
            Player p = (Player)event.getPlayer();
            this.scroll.put(p.getUniqueId(), 0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBiomeMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISTelepathicBiome)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("TelepathicBiomeListener");
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        InventoryView view = event.getView();
        switch (slot) {
            case 8: {
                if (view.getItem(8) == null || this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, this.scroll.get(uuid) + 1, true, uuid);
                break;
            }
            case 17: {
                if (view.getItem(17) == null || this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, this.scroll.get(uuid) - 1, false, uuid);
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
            default: {
                ItemStack choice = view.getItem(slot);
                if (choice == null) break;
                ItemMeta im = choice.getItemMeta();
                String enumStr = ComponentUtils.toEnumUppercase(im.displayName());
                player.performCommand("tardistravel biome " + enumStr);
                this.close(player);
            }
        }
    }

    private void scroll(InventoryView view, int row, boolean up, UUID uuid) {
        if (up && row < this.rows - 5 || !up && row >= 0) {
            this.scroll.put(uuid, row);
            this.setSlots(view, row, uuid);
        } else {
            this.scrolling.remove(uuid);
        }
    }

    private void setSlots(InventoryView view, int row, UUID uuid) {
        int slot = 0;
        for (int r = row; r < row + 6; ++r) {
            for (int c = 0; c < 8; ++c) {
                view.setItem(slot, this.biomes[r][c]);
                if (slot % 9 == 7) {
                    slot += 2;
                    continue;
                }
                ++slot;
            }
        }
        this.scrolling.remove(uuid);
    }

    private ItemStack[][] getBiomes() {
        ItemStack[][] stacks = new ItemStack[this.rows][8];
        int r = 0;
        int c = 0;
        for (Biome biome : EnvironmentBiomes.OVERWORLD) {
            Material material = EnvironmentBiomes.BIOME_BLOCKS.get(biome.getKey().getKey());
            if (material == null) continue;
            ItemStack is = ItemStack.of((Material)material, (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)Component.text((String)TARDISStringUtils.capitalise(biome.getKey().getKey())));
            is.setItemMeta(im);
            stacks[r][c] = is;
            if (++c != 8) continue;
            ++r;
            c = 0;
        }
        return stacks;
    }
}

