/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.interaction;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.ConsoleInteraction;
import me.eccentric_nz.TARDIS.console.models.ButtonModel;
import me.eccentric_nz.TARDIS.control.actions.LightSwitchAction;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;

public class LightSwitchInteraction {
    private final TARDIS plugin;

    public LightSwitchInteraction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void toggle(int id, Player player, Interaction interaction) {
        if (this.plugin.getTrackerKeeper().getFlight().containsKey(player.getUniqueId())) {
            return;
        }
        if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            return;
        }
        Tardis tardis = rs.getTardis();
        if (!tardis.isLightsOn() && this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
            return;
        }
        UUID uuid = (UUID)interaction.getPersistentDataContainer().get(this.plugin.getModelUuidKey(), this.plugin.getPersistentDataTypeUUID());
        if (uuid != null) {
            ItemDisplay display = (ItemDisplay)this.plugin.getServer().getEntity(uuid);
            new ButtonModel().setState(display, this.plugin, ConsoleInteraction.LIGHT_SWITCH);
        }
        new LightSwitchAction(this.plugin, id, tardis.isLightsOn(), player, tardis.getSchematic().getLights()).flickSwitch();
    }
}

