/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.CustomiseConsoleInventory;
import me.eccentric_nz.TARDIS.console.models.ColourType;
import me.eccentric_nz.TARDIS.console.models.ConsoleColourChanger;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetScreenInteraction;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.rotors.Rotor;
import me.eccentric_nz.TARDIS.rotors.TARDISTimeRotor;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class CustomiseConsoleListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, Integer> selectedRotors = new HashMap();
    private final HashMap<UUID, Integer> scrollRotor = new HashMap();
    private final HashMap<UUID, Integer> selectedConsoles = new HashMap();
    private final HashMap<UUID, Integer> scrollConsole = new HashMap();
    private final List<Map.Entry<String, Rotor>> rotorKeys = new ArrayList<Map.Entry<String, Rotor>>(Rotor.byName.entrySet());
    private final List<Map.Entry<Material, NamespacedKey>> consoleKeys = new ArrayList<Map.Entry<Material, NamespacedKey>>(ColourType.BY_MATERIAL.entrySet());

    public CustomiseConsoleListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onCustomiseGuiClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof CustomiseConsoleInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID playerUUID = player.getUniqueId();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        InventoryView view = event.getView();
        switch (slot) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.selectedRotors.put(playerUUID, slot);
                break;
            }
            case 18: {
                int start;
                int max = this.rotorKeys.size() - 9;
                if (this.scrollRotor.containsKey(playerUUID)) {
                    start = this.scrollRotor.get(playerUUID) + 1;
                    if (start >= max) {
                        start = max;
                    }
                } else {
                    start = 1;
                }
                this.scrollRotor.put(playerUUID, start);
                for (int i = 0; i < 9; ++i) {
                    this.setRotorSlot(view, 9 + i, this.rotorKeys.get(start + i));
                }
                break;
            }
            case 26: {
                int start;
                if (this.scrollRotor.containsKey(playerUUID)) {
                    start = this.scrollRotor.get(playerUUID) - 1;
                    if (start <= 0) {
                        start = 0;
                    }
                } else {
                    start = 0;
                }
                this.scrollRotor.put(playerUUID, start);
                for (int i = 0; i < 9; ++i) {
                    this.setRotorSlot(view, 9 + i, this.rotorKeys.get(start + i));
                }
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.selectedConsoles.put(playerUUID, slot);
                break;
            }
            case 36: {
                int start;
                int max = this.consoleKeys.size() - 9;
                if (this.scrollConsole.containsKey(playerUUID)) {
                    start = this.scrollConsole.get(playerUUID) + 1;
                    if (start >= max) {
                        start = max;
                    }
                } else {
                    start = 1;
                }
                this.scrollConsole.put(playerUUID, start);
                for (int i = 0; i < 9; ++i) {
                    this.setConsoleSlot(view, 27 + i, this.consoleKeys.get(start + i));
                }
                break;
            }
            case 44: {
                int start;
                if (this.scrollConsole.containsKey(playerUUID)) {
                    start = this.scrollConsole.get(playerUUID) - 1;
                    if (start <= 0) {
                        start = 0;
                    }
                } else {
                    start = 0;
                }
                this.scrollConsole.put(playerUUID, start);
                for (int i = 0; i < 9; ++i) {
                    this.setConsoleSlot(view, 27 + i, this.consoleKeys.get(start + i));
                }
                break;
            }
            case 49: {
                String uuids;
                Entity screen;
                ResultSetScreenInteraction rssi;
                Rotor rotor;
                ItemFrame itemFrame;
                int cost = 0;
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", playerUUID.toString());
                ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                if (!rs.resultSet()) break;
                int id = rs.getTardis().getTardisId();
                int artron = rs.getTardis().getArtronLevel();
                if (this.selectedRotors.containsKey(playerUUID)) {
                    cost += this.plugin.getArtronConfig().getInt("customise.time_rotor");
                }
                if (this.selectedConsoles.containsKey(playerUUID)) {
                    cost += this.plugin.getArtronConfig().getInt("customise.console");
                }
                if (cost > artron) {
                    this.resetAndClose(player);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NOT_ENOUGH");
                    return;
                }
                if (this.selectedRotors.containsKey(playerUUID) && (itemFrame = TARDISTimeRotor.getItemFrame(rs.getTardis().getRotor())) != null && (rotor = this.getRotorType(view, playerUUID)) != null) {
                    TARDISTimeRotor.setRotor(rotor.offModel(), itemFrame);
                }
                if (this.selectedConsoles.containsKey(playerUUID) && (rssi = new ResultSetScreenInteraction(this.plugin, id)).resultSet() && rssi.getUuid() != null && (screen = this.plugin.getServer().getEntity(rssi.getUuid())) != null && screen.getPersistentDataContainer().has(this.plugin.getUnaryKey(), PersistentDataType.STRING) && (uuids = (String)screen.getPersistentDataContainer().get(this.plugin.getUnaryKey(), PersistentDataType.STRING)) != null) {
                    String colour = this.getConsoleColour(view, playerUUID);
                    new ConsoleColourChanger(this.plugin, screen.getLocation(), uuids, colour).paint();
                }
                if (cost > 0) {
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", id);
                    this.plugin.getQueryFactory().alterEnergyLevel("tardis", -cost, wheret, player);
                }
                this.resetAndClose(player);
                break;
            }
            case 53: {
                this.resetAndClose(player);
                break;
            }
        }
    }

    private Rotor getRotorType(InventoryView view, UUID playerUUID) {
        int slot = this.selectedRotors.get(playerUUID);
        ItemStack is = view.getItem(slot);
        ItemMeta im = is.getItemMeta();
        String r = TARDISStringUtils.toEnumUppercase(ComponentUtils.stripColour(im.displayName()));
        return Rotor.byName.get(r);
    }

    private String getConsoleColour(InventoryView view, UUID playerUUID) {
        int slot = this.selectedConsoles.get(playerUUID);
        ItemStack is = view.getItem(slot);
        Material material = is.getType();
        return ColourType.BY_MATERIAL.get(material).getKey().replace("console_", "");
    }

    void setRotorSlot(InventoryView view, int slot, Map.Entry<String, Rotor> rotor) {
        ItemStack is = ItemStack.of((Material)Material.LIGHT_GRAY_DYE, (int)1);
        ItemMeta im = is.getItemMeta();
        im.setItemModel(rotor.getValue().offModel());
        im.displayName((Component)Component.text((String)TARDISStringUtils.capitalise(rotor.getKey())));
        is.setItemMeta(im);
        view.setItem(slot, is);
    }

    void setConsoleSlot(InventoryView view, int slot, Map.Entry<Material, NamespacedKey> colour) {
        String name = colour.getValue().getKey().replace("console_", "");
        ItemStack is = ItemStack.of((Material)colour.getKey(), (int)1);
        ItemMeta im = is.getItemMeta();
        String dn = TARDISStringUtils.capitalise(name) + " Console";
        im.displayName((Component)ComponentUtils.toWhite(dn));
        is.setItemMeta(im);
        view.setItem(slot, is);
    }

    void resetAndClose(Player player) {
        this.selectedRotors.remove(player.getUniqueId());
        this.selectedConsoles.remove(player.getUniqueId());
        this.close(player);
    }
}

