/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console;

import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetOccupiedScreen;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetScreen;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;

public class ControlMonitor
implements Runnable {
    private final TARDIS plugin;
    private final Transformation transformation = new Transformation(TARDISConstants.VECTOR_ZERO, TARDISConstants.AXIS_ANGLE_ZERO, new Vector3f(0.4f, 0.4f, 0.4f), TARDISConstants.AXIS_ANGLE_ZERO);
    private int modulo = 0;

    public ControlMonitor(TARDIS plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        ResultSetOccupiedScreen rsos = new ResultSetOccupiedScreen(this.plugin);
        rsos.resultSetAsync(resultSetOccupied -> {
            for (Pair<Integer, UUID> pair : rsos.getData()) {
                this.update((Integer)pair.getFirst(), (UUID)pair.getSecond(), this.modulo % 2 == 0);
            }
        });
        ++this.modulo;
        if (this.modulo == 2) {
            this.modulo = 0;
        }
    }

    public void update(int id, UUID uuid, boolean coords) {
        Entity entity = this.plugin.getServer().getEntity(uuid);
        if (!(entity instanceof TextDisplay)) {
            return;
        }
        TextDisplay textDisplay = (TextDisplay)entity;
        textDisplay.setTransformation(this.transformation);
        textDisplay.setBillboard(Display.Billboard.FIXED);
        textDisplay.setBackgroundColor(Color.fromRGB((int)8, (int)10, (int)15));
        textDisplay.setSeeThrough(false);
        ResultSetScreen rss = new ResultSetScreen(this.plugin, id);
        TextComponent.Builder builder = Component.text();
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.color((TextColor)NamedTextColor.DARK_PURPLE)).append((Component)Component.text((String)"Drifting\n"))).append((Component)Component.text((String)"in the\n"))).append((Component)Component.text((String)"time\n"))).append((Component)Component.text((String)"vortex..."));
            textDisplay.text((Component)builder.build());
        } else if (coords) {
            rss.locationAsync((arg_0, arg_1) -> this.lambda$update$1((ComponentBuilder)builder, textDisplay, arg_0, arg_1));
        } else {
            rss.artronAsync((arg_0, arg_1) -> this.lambda$update$2((ComponentBuilder)builder, textDisplay, arg_0, arg_1));
        }
    }

    private /* synthetic */ void lambda$update$2(ComponentBuilder builder, TextDisplay textDisplay, boolean hasResult, ResultSetScreen resultSetConsole) {
        if (hasResult) {
            TextComponent preset;
            ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.text((String)this.plugin.getLanguage().getString("ARTRON_DISPLAY", "Artron Energy"), (TextColor)NamedTextColor.WHITE))).append((Component)Component.newline())).append((Component)Component.text((String)resultSetConsole.getArtronLevel(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.text((String)this.plugin.getLanguage().getString("CHAM_DISPLAY", "Exterior"), (TextColor)NamedTextColor.WHITE))).append((Component)Component.newline());
            if (resultSetConsole.getPreset().startsWith("POLICE_BOX_")) {
                NamedTextColor colour = TARDISStaticUtils.policeBoxToNamedTextColor(resultSetConsole.getPreset());
                preset = Component.text((String)"POLICE_BOX", (TextColor)colour);
            } else {
                preset = Component.text((String)resultSetConsole.getPreset().replace("ITEM:", ""), (TextColor)NamedTextColor.BLUE);
            }
            builder.append((Component)preset);
            textDisplay.text((Component)builder.build());
        }
    }

    private /* synthetic */ void lambda$update$1(ComponentBuilder builder, TextDisplay textDisplay, boolean hasResult, ResultSetScreen resultSetConsole) {
        if (hasResult) {
            String worldName;
            String string = worldName = resultSetConsole.getWorld() != null ? TARDISAliasResolver.getWorldAlias(resultSetConsole.getWorld()) : "";
            if (!this.plugin.getPlanetsConfig().getBoolean("planets." + resultSetConsole.getWorld() + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) && !worldName.isEmpty()) {
                worldName = this.plugin.getMVHelper().getAlias(worldName);
            }
            ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.text((String)worldName))).append((Component)Component.newline())).append((Component)Component.text((String)resultSetConsole.getX(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.newline())).append((Component)Component.text((String)resultSetConsole.getY(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.newline())).append((Component)Component.text((String)resultSetConsole.getZ(), (TextColor)NamedTextColor.WHITE));
            textDisplay.text((Component)builder.build());
        }
    }
}

