/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.ConsoleInteraction;
import me.eccentric_nz.TARDIS.console.interaction.ArtronInteraction;
import me.eccentric_nz.TARDIS.console.interaction.ConsoleLampInteraction;
import me.eccentric_nz.TARDIS.console.interaction.DirectionInteraction;
import me.eccentric_nz.TARDIS.console.interaction.DoorToggleInteraction;
import me.eccentric_nz.TARDIS.console.interaction.FastReturnInteraction;
import me.eccentric_nz.TARDIS.console.interaction.FlightModeInteraction;
import me.eccentric_nz.TARDIS.console.interaction.HandbrakeInteraction;
import me.eccentric_nz.TARDIS.console.interaction.HelmicRegulatorInteraction;
import me.eccentric_nz.TARDIS.console.interaction.LampLevelInteraction;
import me.eccentric_nz.TARDIS.console.interaction.LightLevelInteraction;
import me.eccentric_nz.TARDIS.console.interaction.LightSwitchInteraction;
import me.eccentric_nz.TARDIS.console.interaction.ManualFlightInteraction;
import me.eccentric_nz.TARDIS.console.interaction.MultiplierXZInteraction;
import me.eccentric_nz.TARDIS.console.interaction.RandomiserInteraction;
import me.eccentric_nz.TARDIS.console.interaction.RebuildInteraction;
import me.eccentric_nz.TARDIS.console.interaction.ScannerInteraction;
import me.eccentric_nz.TARDIS.console.interaction.ScreenInteraction;
import me.eccentric_nz.TARDIS.console.interaction.SonicDockInteraction;
import me.eccentric_nz.TARDIS.console.interaction.TelepathicCircuitInteraction;
import me.eccentric_nz.TARDIS.console.interaction.ThrottleInteraction;
import me.eccentric_nz.TARDIS.console.interaction.WayPointInteraction;
import me.eccentric_nz.TARDIS.console.interaction.WorldInteraction;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetInteraction;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;

public class ConsoleInteractionListener
implements Listener {
    private final TARDIS plugin;

    public ConsoleInteractionListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onConsoleInteractionClick(PlayerInteractAtEntityEvent event) {
        UUID uuid;
        ResultSetInteraction rsi;
        Interaction interaction;
        Entity entity = event.getRightClicked();
        if (entity instanceof Interaction && (interaction = (Interaction)entity).getPersistentDataContainer().has(this.plugin.getInteractionUuidKey(), this.plugin.getPersistentDataTypeUUID()) && (rsi = new ResultSetInteraction(this.plugin, uuid = (UUID)interaction.getPersistentDataContainer().get(this.plugin.getInteractionUuidKey(), this.plugin.getPersistentDataTypeUUID()))).resultSet()) {
            ConsoleInteraction ci = rsi.getControl();
            Player player = event.getPlayer();
            if (player.isSneaking() && ci != ConsoleInteraction.SCREEN_LEFT && ci != ConsoleInteraction.SCREEN_RIGHT && ci != ConsoleInteraction.ARTRON) {
                this.plugin.getMessenger().announceRepeater(player, rsi.getControl().getAlternateName());
                return;
            }
            int id = rsi.getTardisId();
            int state = rsi.getState();
            switch (ci) {
                case HANDBRAKE: {
                    new HandbrakeInteraction(this.plugin).process(id, state, player, interaction);
                    break;
                }
                case THROTTLE: {
                    new ThrottleInteraction(this.plugin).process(player, interaction, id);
                    break;
                }
                case RELATIVITY_DIFFERENTIATOR: {
                    new FlightModeInteraction(this.plugin).process(player, id, interaction);
                    break;
                }
                case WORLD: {
                    new WorldInteraction(this.plugin).selectWorld(state, player, interaction, id);
                    break;
                }
                case MULTIPLIER: 
                case X: 
                case Z: {
                    new MultiplierXZInteraction(this.plugin).setRange(ci, state, interaction, id, player);
                    break;
                }
                case HELMIC_REGULATOR: {
                    new HelmicRegulatorInteraction(this.plugin).selectWorld(state, id, player, interaction);
                    break;
                }
                case RANDOMISER: {
                    new RandomiserInteraction(this.plugin).generateDestination(id, player, interaction);
                    break;
                }
                case WAYPOINT_SELECTOR: {
                    new WayPointInteraction(this.plugin).openSaveGUI(id, player, interaction);
                    break;
                }
                case FAST_RETURN: {
                    new FastReturnInteraction(this.plugin).setBack(id, player, interaction);
                    break;
                }
                case TELEPATHIC_CIRCUIT: {
                    new TelepathicCircuitInteraction(this.plugin).process(player);
                    break;
                }
                case SONIC_DOCK: {
                    new SonicDockInteraction(this.plugin).process(player, interaction, id);
                    break;
                }
                case DIRECTION: {
                    new DirectionInteraction(this.plugin).rotate(id, player, interaction);
                    break;
                }
                case LIGHT_SWITCH: {
                    new LightSwitchInteraction(this.plugin).toggle(id, player, interaction);
                    break;
                }
                case INTERIOR_LIGHT_LEVEL_SWITCH: {
                    new LightLevelInteraction(this.plugin).setInterior(state, id, interaction, player);
                    break;
                }
                case EXTERIOR_LAMP_LEVEL_SWITCH: {
                    new LampLevelInteraction(this.plugin).setExterior(state, id, interaction, player);
                    break;
                }
                case CONSOLE_LAMP: {
                    new ConsoleLampInteraction(this.plugin).setLevel(state, id, interaction, player);
                    break;
                }
                case DOOR_TOGGLE: {
                    new DoorToggleInteraction(this.plugin).toggle(id, player, interaction);
                    break;
                }
                case SCREEN_LEFT: 
                case SCREEN_RIGHT: {
                    new ScreenInteraction(this.plugin).display(id, interaction, ci == ConsoleInteraction.SCREEN_RIGHT, player);
                    break;
                }
                case SCANNER: {
                    new ScannerInteraction(this.plugin).process(id, player, interaction);
                    break;
                }
                case ARTRON: {
                    new ArtronInteraction(this.plugin).show(id, player, interaction);
                    break;
                }
                case REBUILD: {
                    new RebuildInteraction(this.plugin).process(id, player, interaction);
                    break;
                }
                case ASTROSEXTANT_RECTIFIER: 
                case ABSOLUTE_TESSERACTULATOR: 
                case GRAVITIC_ANOMALISER: {
                    new ManualFlightInteraction(this.plugin).receiveInput(player.getUniqueId(), interaction);
                    break;
                }
                default: {
                    this.plugin.getMessenger().announceRepeater(player, rsi.getControl().getAlternateName());
                }
            }
        }
    }
}

