/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.TARDISBoundTransmatRemoval;
import me.eccentric_nz.TARDIS.database.data.Transmat;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBind;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTransmat;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTransmatList;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.desktop.PreviewData;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.RoomsWorld;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class TARDISTransmatCommand {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_]{2,16}");
    private final TARDIS plugin;

    TARDISTransmatCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean teleportOrProcess(Player player, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return false;
        }
        if (!TARDISPermission.hasPermission(player, "tardis.transmat")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
            return true;
        }
        ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
        if (!rs.fromUUID(player.getUniqueId().toString())) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
            return true;
        }
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("uuid", player.getUniqueId().toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
        if (!rst.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_TARDIS");
            return false;
        }
        int id = rs.getTardisId();
        int thisid = rst.getTardis_id();
        if (thisid != id) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CMD_ONLY_TL");
            return false;
        }
        if (args[1].equalsIgnoreCase("list")) {
            ResultSetTransmatList rslist;
            Transmat transmat = null;
            if (this.plugin.getPlanetsConfig().getBoolean("planets.rooms.enabled") && this.plugin.getServer().getWorld("rooms") != null) {
                transmat = new RoomsWorld().getTransmat(this.plugin);
            }
            if ((rslist = new ResultSetTransmatList(this.plugin, id)).resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_LIST");
                for (Transmat t : rslist.getData()) {
                    this.plugin.getMessenger().sendTransmat((CommandSender)player, t);
                }
                if (transmat != null) {
                    this.plugin.getMessenger().sendTransmat((CommandSender)player, transmat);
                }
            } else if (transmat != null) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_LIST");
                this.plugin.getMessenger().sendTransmat((CommandSender)player, transmat);
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_NO_LIST");
            }
            return true;
        }
        if (args.length < 3) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return false;
        }
        if (args[1].equalsIgnoreCase("tp")) {
            if (args.length == 6) {
                World world = this.plugin.getServer().getWorld(args[2]);
                if (world != null) {
                    float x = TARDISNumberParsers.parseFloat(args[3]);
                    float y = TARDISNumberParsers.parseFloat(args[4]);
                    float z = TARDISNumberParsers.parseFloat(args[5]);
                    Location tp_loc = new Location(world, (double)x, (double)y, (double)z);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT");
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        player.playSound(tp_loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                        player.teleport(tp_loc);
                    }, 10L);
                }
            } else if (args[2].equalsIgnoreCase("console")) {
                this.plugin.getGeneralKeeper().getRendererListener().transmat(player);
            } else {
                boolean isRoomsWorld;
                ResultSetTransmat rsm;
                if (args[2].startsWith("Rooms") && args.length == 4 && TARDISPermission.hasPermission(player, "tardis.transmat.rooms")) {
                    rsm = new ResultSetTransmat(this.plugin, -1, "rooms");
                    isRoomsWorld = true;
                } else {
                    rsm = new ResultSetTransmat(this.plugin, id, args[2]);
                    isRoomsWorld = false;
                }
                if (rsm.resultSet()) {
                    if (isRoomsWorld) {
                        this.plugin.getTrackerKeeper().getPreviewers().put(player.getUniqueId(), new PreviewData(player.getLocation().clone(), player.getGameMode(), id));
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT");
                    Location tp_loc = rsm.getLocation();
                    tp_loc.setYaw(rsm.getYaw());
                    tp_loc.setPitch(player.getLocation().getPitch());
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        player.playSound(tp_loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                        player.teleport(tp_loc);
                        if (isRoomsWorld) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREVIEW_DONE");
                        }
                    }, 10L);
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_NOT_FOUND");
                }
            }
            return true;
        }
        Location location = player.getLocation();
        if (args[1].equalsIgnoreCase("add")) {
            if (!this.plugin.getUtils().inTARDISWorld(location)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CMD_IN_WORLD");
                return true;
            }
            if (!LETTERS_NUMBERS.matcher(args[2]).matches()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NAME_NOT_VALID");
                return true;
            }
            ResultSetTransmat rsm = new ResultSetTransmat(this.plugin, id, args[2]);
            if (rsm.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_EXISTS");
                return true;
            }
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tardis_id", id);
            set.put("name", args[2]);
            set.put("world", location.getWorld().getName());
            set.put("x", location.getX());
            set.put("y", location.getY());
            set.put("z", location.getZ());
            set.put("yaw", Float.valueOf(location.getYaw()));
            this.plugin.getQueryFactory().doInsert("transmats", set);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_SAVED");
            return true;
        }
        if (args[1].equalsIgnoreCase("update")) {
            ResultSetTransmat rsm = new ResultSetTransmat(this.plugin, id, args[2]);
            if (rsm.resultSet()) {
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("world", location.getWorld().getName());
                set.put("x", location.getX());
                set.put("y", location.getY());
                set.put("z", location.getZ());
                set.put("yaw", Float.valueOf(location.getYaw()));
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                where.put("name", args[2]);
                this.plugin.getQueryFactory().doUpdate("transmats", set, where);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_SAVED");
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_NOT_FOUND");
            }
            return true;
        }
        if (args[1].equalsIgnoreCase("remove")) {
            ResultSetTransmat rsm = new ResultSetTransmat(this.plugin, id, args[2]);
            if (rsm.resultSet()) {
                HashMap<String, Object> wherer = new HashMap<String, Object>();
                wherer.put("transmat_id", rsm.getTransmat_id());
                this.plugin.getQueryFactory().doDelete("transmats", wherer);
                HashMap<String, Object> whered = new HashMap<String, Object>();
                whered.put("tardis_id", id);
                whered.put("name", args[2]);
                ResultSetBind rsd = new ResultSetBind(this.plugin, whered);
                if (rsd.resultSet()) {
                    new TARDISBoundTransmatRemoval(this.plugin, id, args[2]).unbind();
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_REMOVED");
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_NOT_FOUND");
            }
        }
        return false;
    }
}

