/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.preferences;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.universaltranslator.Language;
import me.eccentric_nz.TARDIS.universaltranslator.TranslateData;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class TARDISSetLanguageCommand {
    private final TARDIS plugin;

    public TARDISSetLanguageCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean setLanguagePref(Player player, String[] args) {
        String pref = args[0];
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREF_NEED", pref);
            return false;
        }
        UUID uuid = player.getUniqueId();
        String first = args[1].toUpperCase(Locale.ROOT);
        if (args[0].equalsIgnoreCase("translate") && args[1].equalsIgnoreCase("off")) {
            this.plugin.getTrackerKeeper().getTranslators().remove(uuid);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSLATE_OFF");
        } else {
            Language langFirst;
            try {
                langFirst = Language.valueOf(first);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LANG_NOT_VALID");
                return true;
            }
            if (args[0].equalsIgnoreCase("translate")) {
                Language langSecond;
                if (args.length < 3) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREF_NEED", "language to translate from");
                    return false;
                }
                String second = args[2].toUpperCase(Locale.ROOT);
                try {
                    langSecond = Language.valueOf(second);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LANG_NOT_VALID");
                    return true;
                }
                if (args.length < 4) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREF_NEED", "player name");
                    return false;
                }
                OfflinePlayer sender = this.plugin.getServer().getOfflinePlayer(args[3]);
                if (sender.getPlayer() == null) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLAYER_NOT_VALID");
                    return true;
                }
                String name = sender.getName();
                TranslateData data = new TranslateData(langFirst, langSecond, name);
                this.plugin.getTrackerKeeper().getTranslators().put(uuid, data);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSLATE_ON", name);
            } else {
                HashMap<String, Object> setl = new HashMap<String, Object>();
                setl.put(pref, first);
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", uuid.toString());
                this.plugin.getQueryFactory().doUpdate("player_prefs", setl, where);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREF_SET", TARDISStringUtils.uppercaseFirst(pref));
            }
        }
        return true;
    }
}

