/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.give;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.BlueprintBase;
import me.eccentric_nz.TARDIS.blueprints.BlueprintConsole;
import me.eccentric_nz.TARDIS.blueprints.BlueprintFeature;
import me.eccentric_nz.TARDIS.blueprints.BlueprintPreset;
import me.eccentric_nz.TARDIS.blueprints.BlueprintRoom;
import me.eccentric_nz.TARDIS.blueprints.BlueprintSonic;
import me.eccentric_nz.TARDIS.blueprints.BlueprintTravel;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TARDISGiveTabComplete
extends TARDISCompleter
implements TabCompleter {
    private static final List<String> BLUEPRINT_SUBS = new ArrayList<String>();
    private final Set<String> GIVE_SUBS = new HashSet<String>();
    private final ImmutableList<String> GIVE_KNOWLEDGE = ImmutableList.of((Object)"knowledge", (Object)"1", (Object)"2", (Object)"64");
    private final ImmutableList<String> KIT_SUBS;
    private final List<String> SEED_SUBS = new ArrayList<String>();
    private final List<String> SYSUPS_SUBS = new ArrayList<String>();
    private final List<String> MAT_SUBS = new ArrayList<String>();

    public TARDISGiveTabComplete(TARDIS plugin) {
        this.GIVE_SUBS.add("artron");
        this.GIVE_SUBS.add("blueprint");
        this.GIVE_SUBS.add("kit");
        this.GIVE_SUBS.add("recipes");
        this.GIVE_SUBS.add("seed");
        this.GIVE_SUBS.add("system-upgrade");
        this.GIVE_SUBS.add("tachyon");
        this.GIVE_SUBS.add("acid-bucket");
        this.GIVE_SUBS.add("rust-bucket");
        for (RecipeItem recipeItem : RecipeItem.values()) {
            if (recipeItem.getCategory() == RecipeCategory.SONIC_UPGRADES || recipeItem.getCategory() == RecipeCategory.UNCRAFTABLE) continue;
            this.GIVE_SUBS.add(recipeItem.toTabCompletionString());
        }
        for (String r : TARDIS.plugin.getCustomDoorsConfig().getKeys(false)) {
            this.GIVE_SUBS.add("door-" + r.toLowerCase(Locale.ROOT));
        }
        for (String r : TARDIS.plugin.getCustomRotorsConfig().getKeys(false)) {
            this.GIVE_SUBS.add("time-rotor-" + r.toLowerCase(Locale.ROOT));
        }
        Set kits = plugin.getKitsConfig().getConfigurationSection("kits").getKeys(false);
        this.KIT_SUBS = ImmutableList.copyOf((Collection)kits);
        for (BlueprintBase blueprintBase : BlueprintBase.values()) {
            BLUEPRINT_SUBS.add("BLUEPRINT_BASE_" + blueprintBase.toString());
        }
        for (Enum enum_ : BlueprintConsole.values()) {
            BLUEPRINT_SUBS.add("BLUEPRINT_CONSOLE_" + enum_.toString());
        }
        for (Enum enum_ : BlueprintFeature.values()) {
            BLUEPRINT_SUBS.add("BLUEPRINT_FEATURE_" + enum_.toString());
        }
        for (Enum enum_ : BlueprintPreset.values()) {
            BLUEPRINT_SUBS.add("BLUEPRINT_PRESET_" + enum_.toString());
        }
        for (Enum enum_ : BlueprintRoom.values()) {
            BLUEPRINT_SUBS.add("BLUEPRINT_ROOM_" + enum_.toString());
        }
        for (Enum enum_ : BlueprintSonic.values()) {
            BLUEPRINT_SUBS.add("BLUEPRINT_SONIC_" + enum_.toString());
        }
        for (Enum enum_ : BlueprintTravel.values()) {
            BLUEPRINT_SUBS.add("BLUEPRINT_TRAVEL_" + enum_.toString());
        }
        for (String seed : Desktops.getBY_NAMES().keySet()) {
            if (seed.equals("SMALL") || seed.equals("MEDIUM") || seed.equals("TALL") || seed.equals("ARCHIVE")) continue;
            this.SEED_SUBS.add(seed);
        }
        for (SystemTree systemTree : SystemTree.values()) {
            this.SYSUPS_SUBS.add(systemTree.toString());
        }
        TARDISWalls.BLOCKS.forEach(m -> this.MAT_SUBS.add(m.toString()));
    }

    public static List<String> getBlueprints() {
        return BLUEPRINT_SUBS;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return null;
        }
        if (args.length == 2) {
            return this.partial(lastArg, this.GIVE_SUBS);
        }
        if (args.length == 3) {
            String sub;
            return switch (sub = args[1]) {
                case "kit" -> this.partial(lastArg, (Collection<String>)this.KIT_SUBS);
                case "blueprint" -> this.partial(lastArg, BLUEPRINT_SUBS);
                case "seed" -> this.partial(lastArg, this.SEED_SUBS);
                case "system-upgrade" -> this.partial(lastArg, this.SYSUPS_SUBS);
                default -> this.partial(lastArg, (Collection<String>)this.GIVE_KNOWLEDGE);
            };
        }
        if (args[1].equalsIgnoreCase("seed")) {
            return this.partial(lastArg, this.MAT_SUBS);
        }
        return ImmutableList.of();
    }
}

