/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.bStats.ARSRoomCounts;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.dev.ComponentCommand;
import me.eccentric_nz.TARDIS.commands.dev.ConsoleTextCommand;
import me.eccentric_nz.TARDIS.commands.dev.DebugCommand;
import me.eccentric_nz.TARDIS.commands.dev.HappyCommand;
import me.eccentric_nz.TARDIS.commands.dev.HeadCommand;
import me.eccentric_nz.TARDIS.commands.dev.MannequinCommand;
import me.eccentric_nz.TARDIS.commands.dev.MountCommand;
import me.eccentric_nz.TARDIS.commands.dev.ResourcePackConverterCommand;
import me.eccentric_nz.TARDIS.commands.dev.RomanCommand;
import me.eccentric_nz.TARDIS.commands.dev.StaircaseCommand;
import me.eccentric_nz.TARDIS.commands.dev.StorageContents;
import me.eccentric_nz.TARDIS.commands.dev.SystemTreeCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISAddRegionsCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISBiomeCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISChainCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISChunksCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISDevBoxCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISDevCircuitCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISDevEffectCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISDevInfoCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISDevLabelCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISDevListCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISDevNMSCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISDevRoomsCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISDisplayItemCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISFixStorageCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISFrameCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISFurnaceCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISInteractionCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISTreeCommand;
import me.eccentric_nz.TARDIS.commands.dev.TARDISWikiRecipeCommand;
import me.eccentric_nz.TARDIS.commands.dev.TIPSPreviewSlotInfo;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.monitor.MonitorSnapshot;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.playerprefs.PreferencesDialog;
import me.eccentric_nz.TARDIS.skins.ArchSkins;
import me.eccentric_nz.TARDIS.skins.DoctorSkins;
import me.eccentric_nz.TARDIS.skins.tv.TVInventory;
import me.eccentric_nz.TARDIS.utility.Pluraliser;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import me.eccentric_nz.tardisregeneration.Regenerator;
import me.eccentric_nz.tardisweepingangels.equip.MonsterArmour;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Art;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrushableBlock;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TARDISDevCommand
implements CommandExecutor {
    private final Set<String> firstsStr = Sets.newHashSet((Object[])new String[]{"add_regions", "advancements", "armour", "biome", "box", "brushable", "chain", "chunks", "chunky", "circuit", "component", "dalek", "debug", "dialog", "dismount", "displayitem", "effect", "empty", "frame", "furnace", "gravity", "give", "happy", "head", "interaction", "label", "leather", "list", "mannequin", "monster", "mount", "ntc", "nms", "plurals", "recipe", "regen", "registry", "roman", "rooms", "screen", "skin", "snapshot", "staircase", "stats", "systree", "tis", "tips", "tree", "unmount"});
    private final TARDIS plugin;

    public TARDISDevCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        block212: {
            block213: {
                Object player;
                if (!cmd.getName().equalsIgnoreCase("tardisdev")) break block212;
                if (!(sender instanceof ConsoleCommandSender) && !sender.hasPermission("tardis.admin")) break block213;
                if (args.length == 0) {
                    new TARDISCommandHelper(this.plugin).getCommand("tardisadmin", sender);
                    return true;
                }
                String first = args[0].toLowerCase(Locale.ROOT);
                if (!this.firstsStr.contains(first)) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_NOT_VALID");
                    return false;
                }
                if (args.length == 1) {
                    switch (first) {
                        case "mount": 
                        case "unmount": {
                            if (sender instanceof Player) {
                                Player player2 = (Player)sender;
                                return new MountCommand(this.plugin).test(player2, first.equals("mount"));
                            }
                            return true;
                        }
                        case "add_regions": {
                            return new TARDISAddRegionsCommand(this.plugin).doCheck(sender);
                        }
                        case "biome": {
                            return new TARDISBiomeCommand().reset(sender);
                        }
                        case "chain": {
                            return new TARDISChainCommand(this.plugin).checkSchematics();
                        }
                        case "dalek": {
                            if (!(sender instanceof Player)) break;
                            player = (Player)sender;
                            Location eyeLocation = player.getTargetBlock(null, 16).getLocation();
                            eyeLocation.add(0.5, 1.25, 0.5);
                            eyeLocation.setYaw(player.getLocation().getYaw() - 180.0f);
                            Skeleton skeleton = (Skeleton)eyeLocation.getWorld().spawnEntity(eyeLocation, EntityType.SKELETON);
                            EntityEquipment ee = skeleton.getEquipment();
                            ItemStack head = ItemStack.of((Material)Material.SLIME_BALL);
                            ItemMeta him = head.getItemMeta();
                            him.setItemModel(new NamespacedKey((Plugin)this.plugin, "dalek_independent_head"));
                            EquippableComponent component = him.getEquippable();
                            component.setSlot(EquipmentSlot.HEAD);
                            component.setAllowedEntities(EntityType.SKELETON);
                            him.setEquippable(component);
                            head.setItemMeta(him);
                            ee.setHelmet(head);
                            ItemStack body = ItemStack.of((Material)Material.SLIME_BALL);
                            ItemMeta bim = body.getItemMeta();
                            bim.setItemModel(new NamespacedKey((Plugin)this.plugin, "dalek_body"));
                            body.setItemMeta(bim);
                            ee.setItemInMainHand(body);
                            PotionEffect invisibility = new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false);
                            skeleton.addPotionEffect(invisibility);
                            PotionEffect resistance = new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 360000, 3, false, false);
                            skeleton.addPotionEffect(resistance);
                            break;
                        }
                        case "dialog": {
                            if (sender instanceof Player) {
                                Player player3 = (Player)sender;
                                Dialog dialog = new PreferencesDialog(this.plugin, player3.getUniqueId()).create();
                                Audience.audience((Audience[])new Audience[]{player3}).showDialog((DialogLike)dialog);
                            }
                            return true;
                        }
                        case "empty": {
                            return new TARDISFixStorageCommand(this.plugin).convertStacks();
                        }
                        case "staircase": {
                            if (sender instanceof Player) {
                                Player player4 = (Player)sender;
                                return new StaircaseCommand().spiral(player4);
                            }
                            return false;
                        }
                        case "furnace": {
                            return new TARDISFurnaceCommand(this.plugin).list();
                        }
                        case "gravity": {
                            if (sender instanceof Player) {
                                Player player5;
                                player5.setGravity(!(player5 = (Player)sender).hasGravity());
                            }
                            return true;
                        }
                        case "give": {
                            if (sender instanceof Player) {
                                Player player6 = (Player)sender;
                                new StorageContents(this.plugin).give(player6);
                            }
                            return true;
                        }
                        case "happy": {
                            if (sender instanceof Player) {
                                Player player7 = (Player)sender;
                                new HappyCommand().leash(player7);
                            }
                            return true;
                        }
                        case "head": {
                            if (sender instanceof Player) {
                                Player player8 = (Player)sender;
                                new HeadCommand(this.plugin).giveAPIHead(player8);
                            }
                            return true;
                        }
                        case "interaction": {
                            if (sender instanceof Player) {
                                Player player9 = (Player)sender;
                                return new TARDISInteractionCommand(this.plugin).process(player9.getUniqueId());
                            }
                            return false;
                        }
                        case "leather": {
                            if (sender instanceof Player) {
                                Player player10 = (Player)sender;
                                ItemStack is = ItemStack.of((Material)Material.LEATHER_HORSE_ARMOR);
                                LeatherArmorMeta im = (LeatherArmorMeta)is.getItemMeta();
                                im.setColor(Color.fromRGB((int)255, (int)0, (int)0));
                                im.addItemFlags(ItemFlag.values());
                                im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
                                im.setEquippable(null);
                                CustomModelDataComponent cmdc = im.getCustomModelDataComponent();
                                List<String> strings = List.of("chameleon_tint");
                                cmdc.setStrings(strings);
                                im.setCustomModelDataComponent(cmdc);
                                is.setItemMeta((ItemMeta)im);
                                player10.getInventory().addItem(new ItemStack[]{is});
                                return true;
                            }
                            return false;
                        }
                        case "monster": {
                            if (sender instanceof Player) {
                                Player player11 = (Player)sender;
                                for (Map.Entry<Location, TARDISTeleportLocation> map : this.plugin.getTrackerKeeper().getPortals().entrySet()) {
                                    if (map.getKey().getWorld().getName().contains("TARDIS") || map.getValue().isAbandoned()) continue;
                                    this.plugin.getMessenger().message((CommandSender)player11, "tardisId => " + map.getValue().getTardisId());
                                }
                                this.plugin.getMessenger().message((CommandSender)player11, "End of open portal list.");
                                return true;
                            }
                            return false;
                        }
                        case "ntc": {
                            TARDISStaticUtils.getColor((Component)Component.text((String)"test", (TextColor)NamedTextColor.AQUA));
                            return true;
                        }
                        case "regen": {
                            if (sender instanceof Player) {
                                Player player12 = (Player)sender;
                                new Regenerator().dev(this.plugin, player12, args);
                            }
                            return true;
                        }
                        case "registry": {
                            Registry variants = RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT);
                            for (Art a : variants) {
                                try {
                                    this.plugin.debug(String.valueOf(a) + " " + variants.getKey((Keyed)a).getKey());
                                }
                                catch (NoSuchMethodError | NullPointerException | NoSuchElementException cmdc) {}
                            }
                            return true;
                        }
                        case "skin": {
                            if (sender instanceof Player) {
                                Player player13 = (Player)sender;
                                this.plugin.getSkinChanger().remove(player13);
                            }
                            return true;
                        }
                        case "stats": {
                            ARSRoomCounts arsRoomCounts = new ARSRoomCounts(this.plugin);
                            for (Map.Entry<String, Integer> entry : arsRoomCounts.getRoomCounts().entrySet()) {
                                this.plugin.debug(entry.getKey() + ": " + String.valueOf(entry.getValue()));
                            }
                            this.plugin.debug("Median per TARDIS: " + arsRoomCounts.getMedian());
                            return true;
                        }
                        case "systree": {
                            if (sender instanceof Player) {
                                Player player14 = (Player)sender;
                                return new SystemTreeCommand(this.plugin).open(player14);
                            }
                            return false;
                        }
                        case "tips": {
                            return new TIPSPreviewSlotInfo(this.plugin).display();
                        }
                    }
                }
                switch (first) {
                    case "staircase": {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            switch (args[1]) {
                                case "mark": {
                                    return new StaircaseCommand().mark((Player)player);
                                }
                                case "scan": {
                                    return new StaircaseCommand().scan((Player)player);
                                }
                            }
                            return new StaircaseCommand().smaller((Player)player);
                        }
                        return false;
                    }
                    case "advancements": {
                        TARDISAchievementFactory.checkAdvancement(args[1]);
                        return true;
                    }
                    case "armour": {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            try {
                                Monster monster = Monster.valueOf(args[1].toUpperCase(Locale.ROOT));
                                String slot = EquipmentSlot.valueOf((String)args[2].toUpperCase(Locale.ROOT));
                                if (slot != EquipmentSlot.CHEST && slot != EquipmentSlot.LEGS) {
                                    return false;
                                }
                                ItemStack a = MonsterArmour.makeEquippable(monster, (EquipmentSlot)slot);
                                player.getInventory().addItem(new ItemStack[]{a});
                            }
                            catch (IllegalArgumentException monster) {
                                // empty catch block
                            }
                        }
                        return true;
                    }
                    case "biome": {
                        return new TARDISBiomeCommand().getName(sender);
                    }
                    case "box": {
                        return new TARDISDevBoxCommand(this.plugin).setPreset(sender, args);
                    }
                    case "component": {
                        switch (args[1].toLowerCase(Locale.ROOT)) {
                            case "ars": {
                                new ComponentCommand(this.plugin).writeARS();
                                break;
                            }
                            case "repeater": {
                                new ComponentCommand(this.plugin).writeRepeater();
                                break;
                            }
                            case "key": {
                                new ComponentCommand(this.plugin).writeKey();
                                break;
                            }
                            case "pack": {
                                new ResourcePackConverterCommand(this.plugin).process(sender, args);
                                break;
                            }
                            case "extra": {
                                new ComponentCommand(this.plugin).writeExtra(sender);
                                break;
                            }
                        }
                        return true;
                    }
                    case "debug": {
                        return new DebugCommand(this.plugin).process(sender, args);
                    }
                    case "label": {
                        return new TARDISDevLabelCommand(this.plugin).catalog(sender);
                    }
                    case "nms": {
                        return new TARDISDevNMSCommand(this.plugin).spawn(sender, args);
                    }
                    case "circuit": {
                        return new TARDISDevCircuitCommand(this.plugin).give(sender);
                    }
                    case "tis": {
                        return new TARDISDevInfoCommand(this.plugin).test(sender);
                    }
                    case "list": {
                        return new TARDISDevListCommand(this.plugin).listStuff(sender, args);
                    }
                    case "tree": {
                        return new TARDISTreeCommand(this.plugin).grow(sender, args);
                    }
                    case "recipe": {
                        return new TARDISWikiRecipeCommand(this.plugin).write(sender, args);
                    }
                    case "rooms": {
                        return new TARDISDevRoomsCommand(this.plugin).build(sender, args);
                    }
                    case "roman": {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            new RomanCommand().equip((Player)player, args[1]);
                        }
                        return true;
                    }
                    case "mannequin": {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            new MannequinCommand().equip((Player)player, args[1]);
                        }
                        return true;
                    }
                    case "plurals": {
                        for (Object m : Material.values()) {
                            String str = m.toString().toLowerCase(Locale.ROOT).replace("_", " ");
                            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, str + " --> " + Pluraliser.pluralise(str));
                        }
                        return true;
                    }
                    case "chunks": {
                        return new TARDISChunksCommand(this.plugin).list(sender);
                    }
                    case "chunky": {
                        if (!this.plugin.getPM().isPluginEnabled("Chunky")) {
                            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, "Chunky plugin is not enabled!");
                            return true;
                        }
                        String radius = args.length > 2 ? args[2] : "250";
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "chunky world " + args[1]);
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "chunky radius " + radius);
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "chunky spawn");
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "chunky start");
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "chunky confirm");
                        return true;
                    }
                    case "screen": {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            return new ConsoleTextCommand(this.plugin).move((Player)player, args);
                        }
                        break block212;
                    }
                    case "skin": {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            if (TARDISNumberParsers.isSimpleNumber(args[1])) {
                                this.plugin.getSkinChanger().set((Player)player, switch (args[1]) {
                                    case "1" -> DoctorSkins.FIRST;
                                    case "2" -> DoctorSkins.SECOND;
                                    case "3" -> DoctorSkins.THIRD;
                                    case "4" -> DoctorSkins.FOURTH;
                                    case "5" -> DoctorSkins.FIFTH;
                                    case "6" -> DoctorSkins.SIXTH;
                                    case "7" -> DoctorSkins.SEVENTH;
                                    case "8" -> DoctorSkins.EIGHTH;
                                    case "9" -> DoctorSkins.NINTH;
                                    case "10" -> DoctorSkins.TENTH;
                                    case "11" -> DoctorSkins.ELEVENTH;
                                    case "12" -> DoctorSkins.TWELFTH;
                                    case "13" -> DoctorSkins.THIRTEENTH;
                                    case "14" -> DoctorSkins.FOURTEENTH;
                                    case "15" -> DoctorSkins.FIFTEENTH;
                                    case "16" -> DoctorSkins.WAR;
                                    default -> ArchSkins.HEROBRINE;
                                });
                            } else {
                                player.openInventory(new TVInventory(this.plugin).getInventory());
                            }
                        }
                        return true;
                    }
                    case "snapshot": {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            if (args[1].equals("c")) {
                                player.performCommand("minecraft:clear @s minecraft:filled_map");
                            } else {
                                new MonitorSnapshot(this.plugin).get(args[1].equals("in"), (Player)player);
                            }
                        }
                        return true;
                    }
                    case "displayitem": {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            return new TARDISDisplayItemCommand(this.plugin).display((Player)player, args);
                        }
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                        return true;
                    }
                    case "frame": {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            return new TARDISFrameCommand(this.plugin).toggle((Player)player, args[1].equalsIgnoreCase("lock"), args.length == 3);
                        }
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                        return true;
                    }
                    case "brushable": {
                        if (sender instanceof Player) {
                            player = (Player)sender;
                            if (args.length == 2) {
                                Block block = player.getTargetBlock(null, 8);
                                sender.sendMessage(block.getState().toString());
                            } else {
                                ItemStack sand = ItemStack.of((Material)Material.SUSPICIOUS_SAND);
                                BlockStateMeta sandMeta = (BlockStateMeta)sand.getItemMeta();
                                BrushableBlock blockState = (BrushableBlock)sandMeta.getBlockState();
                                blockState.setItem(player.getInventory().getItemInMainHand());
                                sandMeta.setBlockState((BlockState)blockState);
                                sand.setItemMeta((ItemMeta)sandMeta);
                                player.getInventory().addItem(new ItemStack[]{sand});
                            }
                        }
                        return true;
                    }
                    case "dismount": {
                        if (sender instanceof Player && (player = (Player)sender).getVehicle() != null) {
                            player.getVehicle().eject();
                        }
                        return true;
                    }
                    case "effect": {
                        if (!(sender instanceof Player)) break;
                        player = (Player)sender;
                        return new TARDISDevEffectCommand(this.plugin).show((Player)player, args);
                    }
                }
                break block212;
            }
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ADMIN");
            return false;
        }
        return false;
    }
}

