/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import org.bukkit.command.CommandSender;

public class TARDISChainCommand {
    private final TARDIS plugin;

    public TARDISChainCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean checkSchematics() {
        for (String fileName : Desktops.getBY_PERMS().keySet()) {
            JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", fileName, false);
            if (obj == null) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "The supplied file [" + fileName + ".tschm] is not a TARDIS JSON schematic!");
                return false;
            }
            JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
            int h = dimensions.get("height").getAsInt();
            int w = dimensions.get("width").getAsInt();
            int l = dimensions.get("length").getAsInt();
            JsonArray arr = obj.get("input").getAsJsonArray();
            for (int level = 0; level < h; ++level) {
                JsonArray floor = arr.get(level).getAsJsonArray();
                for (int row = 0; row < w; ++row) {
                    JsonArray r = floor.get(row).getAsJsonArray();
                    for (int col = 0; col < l; ++col) {
                        JsonObject c = r.get(col).getAsJsonObject();
                        this.validateBlockData(c.get("data").getAsString(), fileName);
                    }
                }
            }
        }
        return true;
    }

    private void validateBlockData(String data, String fileName) {
        try {
            this.plugin.getServer().createBlockData(data);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.SEVERE, "The file [" + fileName + ".tschm] contains invalid block data!");
            this.plugin.getMessenger().sendWithColours((CommandSender)this.plugin.getConsole(), TardisModule.SEVERE, "The invalid data was: ", "#FFFFFF", data, "#00AAAA");
        }
    }
}

