/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.config;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.command.CommandSender;

class TARDISSetIntegerCommand {
    private final TARDIS plugin;
    private final List<String> TIPS_SUBS = List.of("400", "800", "1200", "1600");

    TARDISSetIntegerCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean setConfigInt(CommandSender sender, String[] args, String section) {
        int val;
        String first = section.isEmpty() ? args[0].toLowerCase(Locale.ROOT) : section + "." + args[0].toLowerCase(Locale.ROOT);
        String a = args[1];
        if (args[0].toLowerCase(Locale.ROOT).equals("tips_limit") && !this.TIPS_SUBS.contains(a)) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_TIPS");
            return false;
        }
        try {
            val = Integer.parseInt(a);
        }
        catch (NumberFormatException nfe) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_LAST_NUMBER");
            return false;
        }
        if (first.equals("circuits.uses.chameleon_uses")) {
            first = "circuits.uses.chameleon";
        }
        if (first.equals("circuits.uses.invisibility")) {
            first = "circuits.uses.invisibility";
        }
        if (first.equals("preferences.sfx_volume")) {
            TARDISSounds.setVolume(val);
        }
        this.plugin.getConfig().set(first, (Object)val);
        this.plugin.saveConfig();
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_UPDATED", first);
        if (first.equals("allow.force_field")) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "RESTART");
        }
        return true;
    }

    public boolean setConfigInt(CommandSender sender, String[] args) {
        int val;
        String first = args[0];
        String a = args[1];
        try {
            val = Integer.parseInt(a);
        }
        catch (NumberFormatException nfe) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_LAST_NUMBER");
            return false;
        }
        this.plugin.getArtronConfig().set(first, (Object)val);
        try {
            this.plugin.getArtronConfig().save(new File(this.plugin.getDataFolder(), "artron.yml"));
        }
        catch (IOException io) {
            this.plugin.debug("Could not save artron.yml, " + String.valueOf(io));
        }
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_UPDATED", first);
        return true;
    }

    public boolean setRandomInt(CommandSender sender, String[] args) {
        int val;
        String first = args[0];
        if (!first.endsWith(".x") || !first.endsWith(".z")) {
            this.plugin.getMessenger().sendColouredCommand(sender, "ARG_DIRECTION", "/tconfig random_circuit.[x|z] [distance]", this.plugin);
            return true;
        }
        try {
            val = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException nfe) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_LAST_NUMBER");
            return false;
        }
        this.plugin.getConfig().set("travel." + first, (Object)val);
        this.plugin.saveConfig();
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_UPDATED", first);
        return true;
    }
}

