/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISGravityCommands
implements CommandExecutor {
    private final TARDIS plugin;
    private final List<String> directions = new ArrayList<String>();
    private final HashMap<String, Double> gravityDirection = new HashMap();

    public TARDISGravityCommands(TARDIS plugin) {
        this.plugin = plugin;
        this.directions.add("down");
        this.directions.add("up");
        this.directions.add("north");
        this.directions.add("west");
        this.directions.add("south");
        this.directions.add("east");
        this.directions.add("remove");
        this.gravityDirection.put("down", 0.0);
        this.gravityDirection.put("up", 1.0);
        this.gravityDirection.put("north", 2.0);
        this.gravityDirection.put("west", 3.0);
        this.gravityDirection.put("south", 4.0);
        this.gravityDirection.put("east", 5.0);
        this.gravityDirection.put("remove", 6.0);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisgravity")) {
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (player == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                return false;
            }
            if (!TARDISPermission.hasPermission(player, "tardis.gravity")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                return true;
            }
            if (!this.plugin.getConfig().getBoolean("allow.external_gravity") && !this.plugin.getUtils().inTARDISWorld(player)) {
                String mess_stub = player.getLocation().getWorld().getName().toUpperCase(Locale.ROOT).contains("TARDIS_WORLD_") ? "GRAVITY_OWN_WORLD" : "GRAVITY_A_WORLD";
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, mess_stub);
                return true;
            }
            if (args.length < 1) {
                new TARDISCommandHelper(this.plugin).getCommand("tardisgravity", sender);
                return true;
            }
            String dir = args[0].toLowerCase(Locale.ROOT);
            if (this.directions.contains(dir)) {
                Double[] values;
                block15: {
                    values = new Double[3];
                    values[0] = this.gravityDirection.get(dir);
                    if (!dir.equals("remove") && !dir.equals("down")) {
                        if (args.length < 2) {
                            return false;
                        }
                        try {
                            values[1] = Double.parseDouble(args[1]);
                            if (values[1] > this.plugin.getConfig().getDouble("growth.gravity_max_distance")) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FAR");
                                return true;
                            }
                            break block15;
                        }
                        catch (NumberFormatException e) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_SEC_NUMBER");
                            return false;
                        }
                    }
                    values[1] = 0.0;
                }
                if (args.length == 3) {
                    values[2] = TARDISNumberParsers.parseDouble(args[2]);
                    if (values[2] > this.plugin.getConfig().getDouble("growth.gravity_max_velocity")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GRAVITY_FAST");
                        return true;
                    }
                } else {
                    values[2] = 0.5;
                }
                UUID uuid = player.getUniqueId();
                this.plugin.getTrackerKeeper().getGravity().put(uuid, values);
                String message = dir.equals("remove") ? "GRAVITY_CLICK_REMOVE" : "GRAVITY_CLICK_SAVE";
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getTrackerKeeper().getGravity().remove(uuid), 1200L);
                return true;
            }
        }
        return false;
    }
}

