/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.utils;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class PandoricaOpens {
    private final TARDIS plugin;
    private final NamespacedKey[] opening = new NamespacedKey[]{ChameleonVariant.PANDORICA_75.getKey(), ChameleonVariant.PANDORICA_50.getKey(), ChameleonVariant.PANDORICA_25.getKey(), ChameleonVariant.PANDORICA_OPEN.getKey()};
    private final NamespacedKey[] closing = new NamespacedKey[]{ChameleonVariant.PANDORICA_25.getKey(), ChameleonVariant.PANDORICA_50.getKey(), ChameleonVariant.PANDORICA_75.getKey(), ChameleonVariant.PANDORICA_CLOSED.getKey()};
    private final BukkitScheduler scheduler;

    public PandoricaOpens(TARDIS plugin) {
        this.plugin = plugin;
        this.scheduler = this.plugin.getServer().getScheduler();
    }

    public void animate(ArmorStand stand, boolean open) {
        Location location = stand.getLocation();
        while (!location.getChunk().isLoaded()) {
            location.getChunk().load();
        }
        EntityEquipment ee = stand.getEquipment();
        ItemStack is = ee.getHelmet();
        ItemMeta im = is.getItemMeta();
        long delay = 5L;
        for (int i = 0; i < 4; ++i) {
            NamespacedKey model;
            String sound;
            if (open) {
                sound = "pandorica_open";
                model = this.opening[i];
            } else {
                sound = "pandorica_close";
                model = this.closing[i];
            }
            TARDISSounds.playTARDISSound(stand.getLocation(), sound);
            this.scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                im.setItemModel(model);
                is.setItemMeta(im);
                ee.setHelmet(is, true);
            }, delay * (long)i);
        }
    }
}

