/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.gui;

import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonPresets;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISPresetInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final Player player;
    private final Inventory inventory;

    public TARDISPresetInventory(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"Chameleon Presets", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stacks = new ItemStack[54];
        for (ChameleonPreset preset : ChameleonPreset.values()) {
            if (ChameleonPreset.NOT_THESE.contains(preset.getCraftMaterial()) || preset.usesArmourStand() || !TARDISPermission.hasPermission(this.player, "tardis.preset." + preset.toString().toLowerCase(Locale.ROOT))) continue;
            ItemStack is = ItemStack.of((Material)preset.getGuiDisplay(), (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)Component.text((String)preset.getDisplayName()));
            is.setItemMeta(im);
            stacks[preset.getSlot()] = is;
        }
        ItemStack back = ItemStack.of((Material)GUIChameleonPresets.BACK.material(), (int)1);
        ItemMeta but = back.getItemMeta();
        but.displayName((Component)Component.text((String)"Back"));
        back.setItemMeta(but);
        stacks[GUIChameleonPresets.BACK.slot()] = back;
        ItemStack custom = ItemStack.of((Material)GUIChameleonPresets.CUSTOM.material(), (int)1);
        ItemMeta customMeta = custom.getItemMeta();
        customMeta.displayName((Component)Component.text((String)"Custom presets"));
        custom.setItemMeta(customMeta);
        stacks[GUIChameleonPresets.CUSTOM.slot()] = custom;
        ItemStack page = ItemStack.of((Material)GUIChameleonPresets.GO_TO_PAGE_2.material(), (int)1);
        ItemMeta two = page.getItemMeta();
        two.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_PAGE_2", "Go to page 2")));
        page.setItemMeta(two);
        stacks[GUIChameleonPresets.GO_TO_PAGE_2.slot()] = page;
        ItemStack close = ItemStack.of((Material)GUIChameleonPresets.CLOSE.material(), (int)1);
        ItemMeta can = close.getItemMeta();
        can.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(can);
        stacks[GUIChameleonPresets.CLOSE.slot()] = close;
        return stacks;
    }
}

